package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.ISMAHClient;
import com.github.razorplay01.ismah.client.config.ModConfig;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;
import net.minecraft.client.renderer.*;
import com.github.razorplay01.ismah.client.api.ArmorRendererRegistry;
import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.common.mixin.PlayerModelAccessor;
import org.spongepowered.asm.mixin.Unique;

import java.util.List;
import java.util.Optional;

import static com.github.razorplay01.ismah.client.ISMAHClient.LOGGER;

public class RenderUtil {
    private RenderUtil() {
        // []
    }
    //? if >= 1.19 && <= 1.20.1 {
    /*public static void renderArmor(PlayerModel playerModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, net.minecraft.world.entity.HumanoidArm arm) {
        if (player.isInvisible()) return;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty() || armor.is(net.minecraft.world.item.Items.AIR) || !(armor.getItem() instanceof net.minecraft.world.item.ArmorItem))
            return;

        //? if >=1.19.4 {
        ResourceLocation itemId = net.minecraft.core.registries.BuiltInRegistries.ITEM.getKey(armor.getItem()); // For 1.19-1.20; use Registries.ITEM.getKey for 1.21+
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return; // Skip rendering, show normal arm
        }
        //?}

        ModelPart armModel = arm == net.minecraft.world.entity.HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);

        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (net.minecraft.client.model.HumanoidModel<net.minecraft.world.entity.LivingEntity>) playerModel);
        } else {
            net.minecraft.client.model.HumanoidModel armorModel = new net.minecraft.client.model.HumanoidModel<>(
                    net.minecraft.client.model.HumanoidModel.createMesh(new net.minecraft.client.model.geom.builders.CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
            );
            playerModel.copyPropertiesTo(playerModel);

            ModelPart armorArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
            ModelPart playerArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
            armorArm.copyFrom(playerArm);
            armorArm.xRot = 0.0F;

            renderEquipmentLayers(poseStack, buffer, combinedLight, armor, armorArm);
            //? if >= 1.20 && <= 1.20.1 {
            /^net.minecraft.world.item.armortrim.ArmorTrim.getTrim(net.minecraft.client.Minecraft.getInstance().level.registryAccess(), armor).ifPresent(
                    armorTrim -> renderArmorTrim(poseStack, buffer, combinedLight, armorTrim, (net.minecraft.world.item.ArmorItem) armor.getItem(), armorArm));^///?}
            renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(PoseStack matrices, MultiBufferSource vertexConsumers,
                                       int light, ItemStack armor, ModelPart armorArm) {
        net.minecraft.world.item.ArmorItem armorItem = (net.minecraft.world.item.ArmorItem) armor.getItem();

        if (armorItem instanceof net.minecraft.world.item.DyeableArmorItem dyeableArmorItem) {
            int color = dyeableArmorItem.getColor(armor);
            float r = (color >> 16 & 255) / 255.0F;
            float g = (color >> 8 & 255) / 255.0F;
            float b = (color & 255) / 255.0F;
            renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, r, g, b, null);
            renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0F, 1.0F, 1.0F, "overlay");
        } else {
            renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0F, 1.0F, 1.0F, null);
        }
    }

    private static void renderArmorLayer(PoseStack matrices, MultiBufferSource vertexConsumers, int light,
                                  net.minecraft.world.item.ArmorItem armorItem, ModelPart armorPart, float r, float g, float b, String overlay) {
        net.minecraft.resources.ResourceLocation armorTexture = getArmorTexture(armorItem, overlay);
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.armorCutoutNoCull(armorTexture));
        armorPart.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, r, g, b, 1.0F);
    }

    private static net.minecraft.resources.ResourceLocation getArmorTexture(net.minecraft.world.item.ArmorItem armorItem, String overlay) {
        String materialName = armorItem.getMaterial().getName();
        String namespace = "minecraft";  // Default for vanilla
        String baseName = materialName;

        if (materialName.contains(":")) {
            String[] parts = materialName.split(":", 2);  // Split once to get namespace and base
            namespace = parts[0];
            baseName = parts[1];
        }

        String path = "textures/models/armor/" + baseName + "_layer_1" +
                (overlay == null ? "" : "_" + overlay) + ".png";
        return new net.minecraft.resources.ResourceLocation(namespace, path);
    }

    //? if >= 1.20 && <= 1.20.1 {
    /^private static void renderArmorTrim(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, net.minecraft.world.item.armortrim.ArmorTrim armorTrim, net.minecraft.world.item.ArmorItem armorItem, ModelPart humanoidModel) {
        net.minecraft.client.renderer.texture.TextureAtlasSprite textureAtlasSprite = net.minecraft.client.Minecraft.getInstance().getTextureAtlas(net.minecraft.client.renderer.Sheets.ARMOR_TRIMS_SHEET)
                .apply(armorTrim.outerTexture(armorItem.getMaterial()));
        VertexConsumer vertexConsumer = textureAtlasSprite.wrap(multiBufferSource.getBuffer(net.minecraft.client.renderer.Sheets.armorTrimsSheet()));
        humanoidModel.render(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY, 1.0F, 1.0F, 1.0F, 1.0F);
    }^///?}
    *///?}

    //? if 1.21 || 1.21.1 {
    /*public static void renderArmor(net.minecraft.client.model.PlayerModel playerModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, net.minecraft.client.player.AbstractClientPlayer player, net.minecraft.world.entity.HumanoidArm arm) {
        if (player.isInvisible()) return;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty() || armor.is(net.minecraft.world.item.Items.AIR) || !(armor.getItem() instanceof net.minecraft.world.item.ArmorItem)) return;

        ResourceLocation itemId = net.minecraft.core.registries.BuiltInRegistries.ITEM.getKey(armor.getItem());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return; // Skip rendering, show normal arm
        }

        playerModel.attackTime = 0.0F;
        playerModel.crouching = false;
        playerModel.swimAmount = 0.0F;
        playerModel.setupAnim(player, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F);

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);

        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, playerModel);
        } else {
            net.minecraft.client.model.HumanoidModel<net.minecraft.world.entity.LivingEntity> armorModel = new net.minecraft.client.model.HumanoidModel<>(
                    net.minecraft.client.model.HumanoidModel.createMesh(new net.minecraft.client.model.geom.builders.CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
            );
            playerModel.copyPropertiesTo(armorModel);
            ModelPart armorArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
            ModelPart playerArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? ((net.minecraft.client.model.PlayerModel<?>) playerModel).leftArm : ((net.minecraft.client.model.PlayerModel<?>) playerModel).rightArm;
            armorArm.copyFrom(playerArm);
            armorArm.xRot = 0.0F;

            net.minecraft.world.item.ArmorItem armorItem = (net.minecraft.world.item.ArmorItem) armor.getItem();
            renderEquipmentLayers(poseStack, buffer, combinedLight, armor, armorItem, armorArm);
            renderArmorTrim(poseStack, buffer, combinedLight, armor, armorItem, armorArm);
            renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(PoseStack matrices, MultiBufferSource vertexConsumers,
                                              int light, ItemStack armor, net.minecraft.world.item.ArmorItem armorItem, ModelPart armorArm) {
        net.minecraft.world.item.ArmorMaterial armorMaterial = armorItem.getMaterial().value();
        if (!armorMaterial.layers().isEmpty()) {
            int dyeColor = armor.is(net.minecraft.tags.ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(armor, 0) : 0;
            boolean hasFoil = armor.hasFoil();

            for (net.minecraft.world.item.ArmorMaterial.Layer layer : armorMaterial.layers()) {
                int color = getColorForLayer(layer, dyeColor, armor);
                if (color != 0) {
                    net.minecraft.resources.ResourceLocation texture = layer.texture(false);
                    VertexConsumer vertexConsumer = net.minecraft.client.renderer.entity.ItemRenderer.getArmorFoilBuffer(vertexConsumers, RenderType.armorCutoutNoCull(texture), hasFoil);
                    armorArm.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                    hasFoil = false;
                }
            }
        }
    }

    private static int getColorForLayer(net.minecraft.world.item.ArmorMaterial.Layer layer, int dyeColor, ItemStack armor) {
        var dyeable = layer.dyeable();
        if (dyeable) {
            int defaultColor = net.minecraft.util.FastColor.ARGB32.opaque(net.minecraft.world.item.component.DyedItemColor.getOrDefault(armor, -6265536));
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    private static void renderArmorTrim(PoseStack matrices, MultiBufferSource vertexConsumers,
                                        int light, ItemStack armor, net.minecraft.world.item.ArmorItem armorItem, ModelPart armorArm) {
        net.minecraft.world.item.armortrim.ArmorTrim trim = armor.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            net.minecraft.client.renderer.texture.TextureAtlasSprite sprite = net.minecraft.client.Minecraft.getInstance().getTextureAtlas(net.minecraft.client.renderer.Sheets.ARMOR_TRIMS_SHEET)
                    .apply(trim.outerTexture(armorItem.getMaterial()));
            VertexConsumer trimVertexConsumer = sprite.wrap(
                    vertexConsumers.getBuffer(net.minecraft.client.renderer.Sheets.armorTrimsSheet((trim.pattern().value()).decal())));
            armorArm.render(matrices, trimVertexConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
    *///?}


    //? if 1.21.2 || 1.21.3 {
    public static void renderArmor(net.minecraft.class_583 entityModel, class_4587 poseStack, class_4597 buffer, int combinedLight, net.minecraft.class_1306 arm, boolean isSleeveVisible) {
        net.minecraft.class_746 player = net.minecraft.class_310.method_1551().field_1724;
        if (player.method_5767()) return;
        class_1799 armor = player.method_31548().method_7372(2);
        if (armor.method_7960() || armor.method_31574(net.minecraft.class_1802.field_8162) || !(armor.method_7909() instanceof net.minecraft.class_1738)) return;

        class_2960 itemId = net.minecraft.class_7923.field_41178.method_10221(armor.method_7909());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return; // Skip rendering, show normal arm
        }

        net.minecraft.class_10192 equippable = armor.method_57824(net.minecraft.class_9334.field_54196);

        net.minecraft.class_591 playerModel = (net.minecraft.class_591) entityModel;

        class_630 armModel = arm == net.minecraft.class_1306.field_6183 ? playerModel.field_3401 : playerModel.field_27433;
        armModel.method_41923();
        armModel.field_3665 = true;
        playerModel.field_3484.field_3665 = isSleeveVisible;
        playerModel.field_3486.field_3665 = isSleeveVisible;
        playerModel.field_27433.field_3674 = -0.1F;
        playerModel.field_3401.field_3674 = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);

        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (net.minecraft.class_572<net.minecraft.class_10034>) entityModel);
        } else {
            net.minecraft.class_572<net.minecraft.class_10034> armorModel = new net.minecraft.class_572<>(
                    net.minecraft.class_572.method_32011(new net.minecraft.class_5605(1.0f), 0.0f).method_32111().method_32112(64, 32)
            );
            playerModel.method_64254(playerModel);

            class_630 armorArm = arm == net.minecraft.class_1306.field_6182 ? armorModel.field_27433 : armorModel.field_3401;
            class_630 playerArm = arm == net.minecraft.class_1306.field_6182 ? playerModel.field_27433 : playerModel.field_3401;
            armorArm.method_17138(playerArm);
            armorArm.field_3654 = 0.0F;

            renderEquipmentLayers(poseStack, buffer, armor, equippable, armorArm, combinedLight);
            renderArmorTrim(poseStack, buffer, armor, equippable, armorArm, combinedLight);
            renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(class_4587 poseStack, class_4597 vertexConsumers, class_1799 chestplate, net.minecraft.class_10192 equippable, class_630 armorArm, int light) {
        net.minecraft.class_2960 modelId = equippable.comp_3176().orElseThrow();
        java.util.List<net.minecraft.class_10186.class_10189> layers = net.minecraft.class_310.method_1551().method_64036().method_64087(modelId).method_63996(net.minecraft.class_10186.class_10190.field_54125);

        if (!layers.isEmpty()) {
            int dyeColor = chestplate.method_31573(net.minecraft.class_3489.field_48803) ? net.minecraft.class_9282.method_57470(chestplate, 0) : 0;
            boolean hasFoil = chestplate.method_7958();

            for (net.minecraft.class_10186.class_10189 layer : layers) {
                int color = getColorForLayer(layer, dyeColor);
                if (color != 0) {
                    net.minecraft.class_2960 texture = layer.method_64007(net.minecraft.class_10186.class_10190.field_54125);
                    class_4588 vertexConsumer = net.minecraft.class_918.method_27952(vertexConsumers, class_1921.method_25448(texture), hasFoil);
                    armorArm.method_22699(poseStack, vertexConsumer, light, class_4608.field_21444, color);
                    hasFoil = false;
                }
            }
        }
    }

    private static int getColorForLayer(net.minecraft.class_10186.class_10189 layer, int dyeColor) {
        var dyeable = layer.comp_3172();
        if (dyeable.isPresent()) {
            int defaultColor = dyeable.get().comp_3170().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    private static void renderArmorTrim(class_4587 poseStack, class_4597 vertexConsumers, class_1799 chestplate, net.minecraft.class_10192 equippable, class_630 armorArm, int light) {
        net.minecraft.class_8053 trim = chestplate.method_57824(net.minecraft.class_9334.field_49607);
        if (trim != null) {
            net.minecraft.class_2960 modelId = equippable.comp_3176().orElseThrow();
            net.minecraft.class_2960 trimTextureId = trim.method_64019(net.minecraft.class_10186.class_10190.field_54125, modelId);
            net.minecraft.class_1058 trimSprite = net.minecraft.class_310.method_1551().method_1549(net.minecraft.class_4722.field_42071).apply(trimTextureId);
            class_4588 trimConsumer = trimSprite.method_24108(vertexConsumers.getBuffer(net.minecraft.class_4722.method_48480(trim.comp_3180().comp_349().comp_1905())));
            armorArm.method_22698(poseStack, trimConsumer, light, class_4608.field_21444);
        }
    }
    //?}

    //? if >= 1.21.5 && < 1.21.9 {
    /*public static void renderArmor(EntityModel entityModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, HumanoidArm humanoidArm, boolean isSleeveVisible) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty()) return;

        ResourceLocation itemId = net.minecraft.core.registries.BuiltInRegistries.ITEM.getKey(armor.getItem());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return; // Skip rendering, show normal arm
        }

        PlayerModel playerModel = (PlayerModel) entityModel;

        ModelPart armModel = humanoidArm == HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, humanoidArm, (HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState>) entityModel);
        } else {
            net.minecraft.world.item.equipment.Equippable equippable = armor.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent() && equippable.slot() == EquipmentSlot.CHEST) {
                renderEquipment(poseStack, buffer, player, humanoidArm, combinedLight, armor);
            }
        }
    }

    @Unique
    private static void renderEquipment(PoseStack poseStack, MultiBufferSource vertexConsumers, LocalPlayer player, HumanoidArm arm, int light, ItemStack chestplate) {
        net.minecraft.world.item.equipment.Equippable equippable = chestplate.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
        ModelPart armorArm = setupArmorModel(player, arm);
        renderEquipmentLayers(poseStack, vertexConsumers, chestplate, equippable, armorArm, light);
        renderTrim(poseStack, vertexConsumers, chestplate, equippable, armorArm, light);
        renderGlintIfNeeded(poseStack, vertexConsumers, light, chestplate, armorArm);
    }

    @Unique
    private static ModelPart setupArmorModel(LocalPlayer player, HumanoidArm arm) {
        PlayerRenderer playerRenderer = (PlayerRenderer) Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(player);
        PlayerModel playerModel = playerRenderer.getModel();

        HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel = new HumanoidModel<>(
                HumanoidModel.createMesh(new CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
        );

        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        return armorArm;
    }

    @Unique
    private static void renderEquipmentLayers(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> assetId = equippable.assetId().orElseThrow();
        List<net.minecraft.client.resources.model.EquipmentClientInfo.Layer> layers = ((com.github.razorplay01.ismah.common.mixin.EntityRenderDispatcherAccesor) Minecraft.getInstance().getEntityRenderDispatcher())
                .getEquipmentAssetManager()
                .get(assetId)
                .getLayers(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);

        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(chestplate, 0) : 0;
            boolean hasFoil = chestplate.hasFoil();

            for (net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer : layers) {
                int color = getColorForLayer(layer, dyeColor);
                if (color != 0) {
                    ResourceLocation texture = layer.getTextureLocation(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);
                    VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(vertexConsumers, RenderType.armorCutoutNoCull(texture), hasFoil);
                    armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                    hasFoil = false;
                }
            }
        }
    }

    @Unique
    private static int getColorForLayer(net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer, int dyeColor) {
        var dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = dyeable.get().colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    @Unique
    private static void renderTrim(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        net.minecraft.world.item.equipment.trim.ArmorTrim trim = chestplate.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> assetId = equippable.assetId().orElseThrow();

            ResourceLocation patternAssetId = trim.pattern().value().assetId();
            String materialSuffix = getColorPaletteSuffix(trim.material(), assetId);
            ResourceLocation trimTextureId = patternAssetId.withPath(p -> "trims/entity/" + net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID.getSerializedName() + "/" + p + "_" + materialSuffix);

            TextureAtlasSprite trimSprite = Minecraft.getInstance().getTextureAtlas(Sheets.ARMOR_TRIMS_SHEET).apply(trimTextureId);
            VertexConsumer trimConsumer = trimSprite.wrap(vertexConsumers.getBuffer(Sheets.armorTrimsSheet(trim.pattern().value().decal())));
            armorArm.render(poseStack, trimConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }

    @Unique
    private static String getColorPaletteSuffix(Holder<net.minecraft.world.item.equipment.trim.TrimMaterial> trimMaterial, ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> equipmentAsset) {
        net.minecraft.world.item.equipment.trim.MaterialAssetGroup assets = trimMaterial.value().assets();
        net.minecraft.world.item.equipment.trim.MaterialAssetGroup.AssetInfo assetInfo = assets.assetId(equipmentAsset);
        return assetInfo.suffix();
    }
    *///?}

    //? if >= 1.21.9 {
    /*public static void renderArmor(EntityModel entityModel, PoseStack poseStack, SubmitNodeCollector submitNodeCollector,
                                   int combinedLight, HumanoidArm humanoidArm, boolean isSleeveVisible) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty()) return;

        ResourceLocation itemId = net.minecraft.core.registries.BuiltInRegistries.ITEM.getKey(armor.getItem());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return; // Skip rendering, show normal arm
        }

        PlayerModel playerModel = (PlayerModel) entityModel; // Genérico para 1.21.9

        ModelPart armModel = humanoidArm == HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, submitNodeCollector, combinedLight, armor, humanoidArm,
                    (HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState>) entityModel);
        } else {
            net.minecraft.world.item.equipment.Equippable equippable = armor.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent() && equippable.slot() == EquipmentSlot.CHEST) {
                renderEquipment(poseStack, submitNodeCollector, player, humanoidArm, combinedLight, armor);
            }
        }
    }

    @Unique
    private static void renderEquipment(PoseStack poseStack, SubmitNodeCollector submitNodeCollector,
                                        LocalPlayer player, HumanoidArm arm, int light, ItemStack chestplate) {
        net.minecraft.world.item.equipment.Equippable equippable = chestplate.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
        ModelPart armorArm = setupArmorModel(player, arm);

        renderEquipmentLayers(poseStack, submitNodeCollector, chestplate, equippable, armorArm, light);
        renderTrim(poseStack, submitNodeCollector, chestplate, equippable, armorArm, light);
        renderGlintIfNeeded(poseStack, submitNodeCollector, light, chestplate, armorArm);
    }

    @Unique
    private static ModelPart setupArmorModel(LocalPlayer player, HumanoidArm arm) {
        AvatarRenderer playerRenderer = (AvatarRenderer) Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(player);
        PlayerModel playerModel = (PlayerModel) playerRenderer.getModel();

        HumanoidModel armorModel = new HumanoidModel<>(
                HumanoidModel.createMesh(new CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
        );

        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.loadPose(playerArm.storePose());

        return armorArm;
    }

    @Unique
    private static void renderEquipmentLayers(PoseStack poseStack, SubmitNodeCollector ordered,
                                              ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable,
                                              ModelPart armorArm, int light) {
        ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> assetId = equippable.assetId().orElseThrow();
        List<net.minecraft.client.resources.model.EquipmentClientInfo.Layer> layers =
                ((com.github.razorplay01.ismah.common.mixin.EntityRenderDispatcherAccesor)
                        Minecraft.getInstance().getEntityRenderDispatcher())
                        .getEquipmentAssetManager()
                        .get(assetId)
                        .getLayers(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);

        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(chestplate, 0) : 0;

            for (net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer : layers) {
                int color = getColorForLayer(layer, dyeColor);
                if (color != 0) {
                    ResourceLocation texture = layer.getTextureLocation(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);
                    RenderType renderType = RenderType.armorCutoutNoCull(texture);

                    // FIX: Params completos + packed color con alpha=255
                    int packedColor = (color & 0xFFFFFF) | 0xFF000000; // Asegura alpha full
                    ordered.submitModelPart(armorArm, poseStack, renderType, light, OverlayTexture.NO_OVERLAY,
                            null, // Sprite null
                            false, false, // No cull/flip
                            packedColor, // Tint packed
                            null, // No crumbling
                            0); // Offset 0 para base
                }
            }
        }
    }

    @Unique
    private static int getColorForLayer(net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer, int dyeColor) {
        var dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = dyeable.get().colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? (dyeColor | 0xFF000000) : defaultColor; // FIX: Packed con alpha
        }
        return -1;
    }

    @Unique
    private static void renderTrim(PoseStack poseStack, OrderedSubmitNodeCollector ordered,
                                   ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable,
                                   ModelPart armorArm, int light) {
        net.minecraft.world.item.equipment.trim.ArmorTrim trim = chestplate.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> assetId = equippable.assetId().orElseThrow();

            ResourceLocation patternAssetId = trim.pattern().value().assetId();
            String materialSuffix = getColorPaletteSuffix(trim.material(), assetId);
            ResourceLocation trimTextureId = patternAssetId.withPath(p ->
                    "trims/entity/" + net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID.getSerializedName() + "/" + p + "_" + materialSuffix
            );

            // Sprite del trim (igual que antes)
            Material trimMaterial = new Material(Sheets.ARMOR_TRIMS_SHEET, trimTextureId);
            TextureAtlasSprite trimSprite = Minecraft.getInstance().getAtlasManager().get(trimMaterial);

            // RenderType para el trim (igual que antes)
            RenderType trimRenderType = Sheets.armorTrimsSheet(trim.pattern().value().decal());
            // Submit el ModelPart (reemplaza render + getBuffer/wrap)
            // Orden implícito en ordered; usa offset 1 si quieres sobre layers
            ordered.submitModelPart(armorArm, poseStack, trimRenderType, light, OverlayTexture.NO_OVERLAY,
                    trimSprite, // Sprite para UV/texture mapping
                    false, // bl: No cull (para transparencias en trims)
                    false, // bl2: No flip
                    -1, // k: No tint (trims usan sprite color; ajusta si material tint)
                    null, // CrumblingOverlay: null
                    0); // l: Offset Z=1 para render sobre layers base
        }
    }

    @Unique
    private static String getColorPaletteSuffix(Holder<net.minecraft.world.item.equipment.trim.TrimMaterial> trimMaterial,
                                                ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> equipmentAsset) {
        net.minecraft.world.item.equipment.trim.MaterialAssetGroup assets = trimMaterial.value().assets();
        net.minecraft.world.item.equipment.trim.MaterialAssetGroup.AssetInfo assetInfo = assets.assetId(equipmentAsset);
        return assetInfo.suffix();
    }
    *///?}

    //? if >= 1.19.2 && < 1.21.9 {
    private static void renderGlintIfNeeded(class_4587 matrices, class_4597 vertexConsumers,
                                            int light, class_1799 armor, class_630 armorArm) {
        if (armor.method_7958()) {
            class_4588 glintConsumer = vertexConsumers.getBuffer(class_1921.method_23591());
            armorArm.method_22698(matrices, glintConsumer, light, class_4608.field_21444);
        }
    }
    //?}
    //? if >= 1.21.9 {
    /*@Unique
    private static void renderGlintIfNeeded(PoseStack poseStack, SubmitNodeCollector ordered,
                                            int light, ItemStack armor, ModelPart armorArm) {
        if (armor.hasFoil()) {
            ordered.submitModelPart(armorArm, poseStack, RenderType.armorEntityGlint(), light, OverlayTexture.NO_OVERLAY,
                    null);
        }
    }
    *///?}
}
