/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.api.ArmorRendererRegistry;
import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.client.config.ModConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10034;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_1058;
import net.minecraft.class_1306;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5605;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8053;
import net.minecraft.class_8056;
import net.minecraft.class_918;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class RenderUtil {
    private RenderUtil() {
    }

    public static void renderArmor(class_583 entityModel, class_4587 poseStack, class_4597 buffer, int combinedLight, class_1306 arm, boolean isSleeveVisible) {
        class_746 player = class_310.method_1551().field_1724;
        if (player.method_5767()) {
            return;
        }
        class_1799 armor = player.method_31548().method_7372(2);
        if (armor.method_7960() || armor.method_31574(class_1802.field_8162) || !(armor.method_7909() instanceof class_1738)) {
            return;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)armor.method_7909());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return;
        }
        class_10192 equippable = (class_10192)armor.method_57824(class_9334.field_54196);
        class_591 playerModel = (class_591)entityModel;
        class_630 armModel = arm == class_1306.field_6183 ? playerModel.field_3401 : playerModel.field_27433;
        armModel.method_41923();
        armModel.field_3665 = true;
        playerModel.field_3484.field_3665 = isSleeveVisible;
        playerModel.field_3486.field_3665 = isSleeveVisible;
        playerModel.field_27433.field_3674 = -0.1f;
        playerModel.field_3401.field_3674 = 0.1f;
        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (class_572<class_10034>)((class_572)entityModel));
        } else {
            class_572 armorModel = new class_572(class_572.method_32011((class_5605)new class_5605(1.0f), (float)0.0f).method_32111().method_32112(64, 32));
            playerModel.method_64254((class_572)playerModel);
            class_630 armorArm = arm == class_1306.field_6182 ? armorModel.field_27433 : armorModel.field_3401;
            class_630 playerArm = arm == class_1306.field_6182 ? playerModel.field_27433 : playerModel.field_3401;
            armorArm.method_17138(playerArm);
            armorArm.field_3654 = 0.0f;
            RenderUtil.renderEquipmentLayers(poseStack, buffer, armor, equippable, armorArm, combinedLight);
            RenderUtil.renderArmorTrim(poseStack, buffer, armor, equippable, armorArm, combinedLight);
            RenderUtil.renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(class_4587 poseStack, class_4597 vertexConsumers, class_1799 chestplate, class_10192 equippable, class_630 armorArm, int light) {
        class_2960 modelId = (class_2960)equippable.comp_3176().orElseThrow();
        List layers = class_310.method_1551().method_64036().method_64087(modelId).method_63996(class_10186.class_10190.field_54125);
        if (!layers.isEmpty()) {
            int dyeColor = chestplate.method_31573(class_3489.field_48803) ? class_9282.method_57470((class_1799)chestplate, (int)0) : 0;
            boolean hasFoil = chestplate.method_7958();
            for (class_10186.class_10189 layer : layers) {
                int color = RenderUtil.getColorForLayer(layer, dyeColor);
                if (color == 0) continue;
                class_2960 texture = layer.method_64007(class_10186.class_10190.field_54125);
                class_4588 vertexConsumer = class_918.method_27952((class_4597)vertexConsumers, (class_1921)class_1921.method_25448((class_2960)texture), (boolean)hasFoil);
                armorArm.method_22699(poseStack, vertexConsumer, light, class_4608.field_21444, color);
                hasFoil = false;
            }
        }
    }

    private static int getColorForLayer(class_10186.class_10189 layer, int dyeColor) {
        Optional dyeable = layer.comp_3172();
        if (dyeable.isPresent()) {
            int defaultColor = ((class_10186.class_10188)dyeable.get()).comp_3170().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    private static void renderArmorTrim(class_4587 poseStack, class_4597 vertexConsumers, class_1799 chestplate, class_10192 equippable, class_630 armorArm, int light) {
        class_8053 trim = (class_8053)chestplate.method_57824(class_9334.field_49607);
        if (trim != null) {
            class_2960 modelId = (class_2960)equippable.comp_3176().orElseThrow();
            class_2960 trimTextureId = trim.method_64019(class_10186.class_10190.field_54125, modelId);
            class_1058 trimSprite = (class_1058)class_310.method_1551().method_1549(class_4722.field_42071).apply(trimTextureId);
            class_4588 trimConsumer = trimSprite.method_24108(vertexConsumers.getBuffer(class_4722.method_48480((boolean)((class_8056)trim.comp_3180().comp_349()).comp_1905())));
            armorArm.method_22698(poseStack, trimConsumer, light, class_4608.field_21444);
        }
    }

    private static void renderGlintIfNeeded(class_4587 matrices, class_4597 vertexConsumers, int light, class_1799 armor, class_630 armorArm) {
        if (armor.method_7958()) {
            class_4588 glintConsumer = vertexConsumers.getBuffer(class_1921.method_23591());
            armorArm.method_22698(matrices, glintConsumer, light, class_4608.field_21444);
        }
    }
}

