package com.github.razorplay01.ismah.client.api;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;

/**
 * Interface for custom armor renderers in first-person view.
 * Mod developers can implement this interface to define how their armor items should be rendered
 * on the player's arm in first-person perspective when registered with {@link ArmorRendererRegistry}.
 */
public interface CustomArmorRenderer {
    /**
     * Determines whether this renderer can handle the given armor ItemStack.
     * This method is called to check if the renderer should be used for a specific item.
     *
     * @param stack The ItemStack of the equipped armor.
     * @return {@code true} if this renderer should handle the ItemStack, {@code false} otherwise.
     */
    boolean canRender(ItemStack stack);

    //? if >= 1.19 && <= 1.20.1 {
    /*void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.world.entity.LivingEntity> playerModel);

    default void renderArmor(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.world.entity.LivingEntity> playerModel, HumanoidModel<net.minecraft.world.entity.LivingEntity> armorModel, ResourceLocation texture) {
        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(bufferSource, RenderType.armorCutoutNoCull(texture), stack.hasFoil(), true);
        armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
    }
    *///?}

    //? if 1.21 || 1.21.1 {
    void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.world.entity.LivingEntity> playerModel);

    default void renderArmor(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.world.entity.LivingEntity> playerModel, HumanoidModel<net.minecraft.world.entity.LivingEntity> armorModel, ResourceLocation texture) {
        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(bufferSource, RenderType.armorCutoutNoCull(texture), stack.hasFoil());
        armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
    }
    //?}

    //? if 1.21.2 || 1.21.3 || 1.21.4 {
    /*void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> playerModel);

    default void renderArmor(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> playerModel, HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel, ResourceLocation texture) {
        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(bufferSource, RenderType.armorCutoutNoCull(texture), stack.hasFoil());
        armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
    }
    *///?}

    //? if >= 1.21.5 {
    /*void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> playerModel);

    default void renderArmor(PoseStack poseStack, MultiBufferSource bufferSource, int light, ItemStack stack, HumanoidArm arm, HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> playerModel, HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel, ResourceLocation texture) {
        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(bufferSource, RenderType.armorCutoutNoCull(texture), stack.hasFoil());
        armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
    }
    *///?}
}