package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.common.mixin.PlayerModelAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

import static com.github.razorplay01.ismah.client.util.LeashRenderer.*;

//? if <=1.21.1 {
public class LeashRenderLayer<T extends LivingEntity, M extends EntityModel<T>> extends RenderLayer<T, M> {
    public LeashRenderLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T entity,
                       float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (entity instanceof Player player) {
            if (((LeashStateAccess) player).getLeashState()) {
                net.minecraft.client.model.PlayerModel<net.minecraft.world.entity.player.Player> model = (PlayerModel<Player>) this.getParentModel();
                if (player.getMainArm() == HumanoidArm.RIGHT) {
                    ModelPart leash = ((PlayerModelAccessor) model).isSlim() ? RIGHT_LEASH_SLIM : RIGHT_LEASH;
                    renderArmLeash(poseStack, multiBufferSource, light, model.rightArm, leash);
                } else {
                    ModelPart leash = ((PlayerModelAccessor) model).isSlim() ? LEFT_LEASH_SLIM : LEFT_LEASH;
                    renderArmLeash(poseStack, multiBufferSource, light, model.leftArm, leash);
                }
            }
        }
    }
}
//?}
//? if > 1.21.1 {
/*public class LeashRenderLayer<T extends net.minecraft.client.renderer.entity.state.PlayerRenderState, M extends EntityModel<T>> extends RenderLayer<T, M> {
    public LeashRenderLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T entityRenderState, float f, float g) {
        if (((PlayerRenderStateAccessor) entityRenderState).getPlayer() instanceof Player player && ((LeashStateAccess) player).getLeashState()) {
            PlayerModel model = (PlayerModel) this.getParentModel();
            boolean isRightArm = entityRenderState.mainArm == HumanoidArm.RIGHT;
            boolean isSlim = ((PlayerModelAccessor) model).isSlim();
            ModelPart leash = isRightArm ? (isSlim ? RIGHT_LEASH_SLIM : RIGHT_LEASH) : (isSlim ? LEFT_LEASH_SLIM : LEFT_LEASH);
            ModelPart arm = isRightArm ? model.rightArm : model.leftArm;
            renderArmLeash(poseStack, multiBufferSource, light, arm, leash);
        }
    }
}
*///?}
