/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.common.mixin;

import com.github.razorplay01.ismah.client.util.LeashRenderLayer;
import com.github.razorplay01.ismah.client.util.LeashStateAccess;
import com.github.razorplay01.ismah.client.util.LivingEntityRenderStateAccessor;
import com.github.razorplay01.ismah.common.mixin.LivingEntityRendererAccessor;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AvatarRenderer.class})
public abstract class PlayerRendererMixin<AvatarlikeEntity extends Avatar>
extends LivingEntityRenderer<AvatarlikeEntity, AvatarRenderState, PlayerModel> {
    private LeashRenderLayer leashRenderLayer;
    private HumanoidArmorLayer humanoidArmorLayer;

    protected PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel entityModel, float shadowRadius) {
        super(context, (EntityModel)entityModel, shadowRadius);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;Z)V"}, at={@At(value="RETURN")})
    public void init(EntityRendererProvider.Context context, boolean bl, CallbackInfo ci) {
        this.leashRenderLayer = new LeashRenderLayer((AvatarRenderer)this);
        ((LivingEntityRendererAccessor)((Object)this)).invokeAddFeature(this.leashRenderLayer);
    }

    @WrapOperation(method={"<init>(Lnet/minecraft/client/renderer/entity/EntityRendererProvider$Context;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/player/AvatarRenderer;addLayer(Lnet/minecraft/client/renderer/entity/layers/RenderLayer;)Z")})
    private boolean getHumanoidRenderLayer(AvatarRenderer<?> instance, RenderLayer<AvatarRenderState, PlayerModel> featureRenderer, Operation<Boolean> original) {
        if (featureRenderer instanceof HumanoidArmorLayer) {
            HumanoidArmorLayer armor;
            this.humanoidArmorLayer = armor = (HumanoidArmorLayer)featureRenderer;
        }
        return (Boolean)original.call(new Object[]{instance, featureRenderer});
    }

    @WrapOperation(method={"renderHand(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/model/geom/ModelPart;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/SubmitNodeCollector;submitModelPart(Lnet/minecraft/client/model/geom/ModelPart;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/RenderType;IILnet/minecraft/client/renderer/texture/TextureAtlasSprite;)V")})
    private void renderArmor(SubmitNodeCollector instance, ModelPart modelPart, PoseStack poseStack, RenderType renderType, int light, int overlay, TextureAtlasSprite textureAtlasSprite, Operation<Void> original) {
        HumanoidArm arm = modelPart == ((PlayerModel)this.model).leftArm ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
        Minecraft client = Minecraft.getInstance();
        LocalPlayer player = client.player;
        if (player == null) {
            original.call(new Object[]{instance, modelPart, poseStack, renderType, light, overlay, textureAtlasSprite});
            return;
        }
        AvatarRenderState renderState = (AvatarRenderState)this.createRenderState((Entity)player, client.getDeltaTracker().getGameTimeDeltaTicks());
        renderState.outlineColor = 0;
        if (!player.isInvisible()) {
            original.call(new Object[]{instance, modelPart, poseStack, renderType, light, overlay, textureAtlasSprite});
        }
        if (this.leashRenderLayer == null) {
            return;
        }
        if (((LeashStateAccess)player).getLeashState()) {
            this.leashRenderLayer.submit(poseStack, instance, light, renderState, renderState.bodyRot, renderState.xRot);
        }
        if (this.humanoidArmorLayer == null) {
            return;
        }
        if (!renderState.chestEquipment.isEmpty()) {
            ((LivingEntityRenderStateAccessor)renderState).setHumanoidArm(arm);
            this.humanoidArmorLayer.submit(poseStack, instance, light, (HumanoidRenderState)renderState, renderState.bodyRot, renderState.xRot);
        }
    }

    @Inject(method={"Lnet/minecraft/client/renderer/entity/player/AvatarRenderer;extractRenderState(Lnet/minecraft/world/entity/Avatar;Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;F)V"}, at={@At(value="RETURN")})
    private void onExtractRenderState(AvatarlikeEntity avatar, AvatarRenderState avatarRenderState, float f, CallbackInfo ci) {
        ((LivingEntityRenderStateAccessor)avatarRenderState).setEntity((Entity)avatar);
    }
}

