package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.ISMAHClient;
import com.github.razorplay01.ismah.client.config.ModConfig;
import net.minecraft.class_1007;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_11785;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_5605;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.client.renderer.*;
import com.github.razorplay01.ismah.client.api.ArmorRendererRegistry;
import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.common.mixin.PlayerModelAccessor;
import org.spongepowered.asm.mixin.Unique;

import java.util.List;
import java.util.Optional;

import static com.github.razorplay01.ismah.client.ISMAHClient.LOGGER;

public class RenderUtil {
    private RenderUtil() {
        // []
    }
    //? if >= 1.19 && <= 1.20.1 {
    /*public static void renderArmor(PlayerModel playerModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, net.minecraft.world.entity.HumanoidArm arm) {
        if (player.isInvisible()) return;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty() || armor.is(net.minecraft.world.item.Items.AIR) || !(armor.getItem() instanceof net.minecraft.world.item.ArmorItem))
            return;

        //? if >=1.19.4 {
        ResourceLocation itemId = net.minecraft.core.registries.BuiltInRegistries.ITEM.getKey(armor.getItem()); // For 1.19-1.20; use Registries.ITEM.getKey for 1.21+
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return; // Skip rendering, show normal arm
        }
        //?}

        ModelPart armModel = arm == net.minecraft.world.entity.HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);

        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (net.minecraft.client.model.HumanoidModel<net.minecraft.world.entity.LivingEntity>) playerModel);
        } else {
            net.minecraft.client.model.HumanoidModel armorModel = new net.minecraft.client.model.HumanoidModel<>(
                    net.minecraft.client.model.HumanoidModel.createMesh(new net.minecraft.client.model.geom.builders.CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
            );
            playerModel.copyPropertiesTo(playerModel);

            ModelPart armorArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
            ModelPart playerArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
            armorArm.copyFrom(playerArm);
            armorArm.xRot = 0.0F;

            renderEquipmentLayers(poseStack, buffer, combinedLight, armor, armorArm);
            //? if >= 1.20 && <= 1.20.1 {
            /^net.minecraft.world.item.armortrim.ArmorTrim.getTrim(net.minecraft.client.Minecraft.getInstance().level.registryAccess(), armor).ifPresent(
                    armorTrim -> renderArmorTrim(poseStack, buffer, combinedLight, armorTrim, (net.minecraft.world.item.ArmorItem) armor.getItem(), armorArm));^///?}
            renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(PoseStack matrices, MultiBufferSource vertexConsumers,
                                       int light, ItemStack armor, ModelPart armorArm) {
        net.minecraft.world.item.ArmorItem armorItem = (net.minecraft.world.item.ArmorItem) armor.getItem();

        if (armorItem instanceof net.minecraft.world.item.DyeableArmorItem dyeableArmorItem) {
            int color = dyeableArmorItem.getColor(armor);
            float r = (color >> 16 & 255) / 255.0F;
            float g = (color >> 8 & 255) / 255.0F;
            float b = (color & 255) / 255.0F;
            renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, r, g, b, null);
            renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0F, 1.0F, 1.0F, "overlay");
        } else {
            renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0F, 1.0F, 1.0F, null);
        }
    }

    private static void renderArmorLayer(PoseStack matrices, MultiBufferSource vertexConsumers, int light,
                                  net.minecraft.world.item.ArmorItem armorItem, ModelPart armorPart, float r, float g, float b, String overlay) {
        net.minecraft.resources.ResourceLocation armorTexture = getArmorTexture(armorItem, overlay);
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.armorCutoutNoCull(armorTexture));
        armorPart.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, r, g, b, 1.0F);
    }

    private static net.minecraft.resources.ResourceLocation getArmorTexture(net.minecraft.world.item.ArmorItem armorItem, String overlay) {
        String materialName = armorItem.getMaterial().getName();
        String namespace = "minecraft";  // Default for vanilla
        String baseName = materialName;

        if (materialName.contains(":")) {
            String[] parts = materialName.split(":", 2);  // Split once to get namespace and base
            namespace = parts[0];
            baseName = parts[1];
        }

        String path = "textures/models/armor/" + baseName + "_layer_1" +
                (overlay == null ? "" : "_" + overlay) + ".png";
        return new net.minecraft.resources.ResourceLocation(namespace, path);
    }

    //? if >= 1.20 && <= 1.20.1 {
    /^private static void renderArmorTrim(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, net.minecraft.world.item.armortrim.ArmorTrim armorTrim, net.minecraft.world.item.ArmorItem armorItem, ModelPart humanoidModel) {
        net.minecraft.client.renderer.texture.TextureAtlasSprite textureAtlasSprite = net.minecraft.client.Minecraft.getInstance().getTextureAtlas(net.minecraft.client.renderer.Sheets.ARMOR_TRIMS_SHEET)
                .apply(armorTrim.outerTexture(armorItem.getMaterial()));
        VertexConsumer vertexConsumer = textureAtlasSprite.wrap(multiBufferSource.getBuffer(net.minecraft.client.renderer.Sheets.armorTrimsSheet()));
        humanoidModel.render(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY, 1.0F, 1.0F, 1.0F, 1.0F);
    }^///?}
    *///?}

    //? if 1.21 || 1.21.1 {
    /*public static void renderArmor(net.minecraft.client.model.PlayerModel playerModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, net.minecraft.client.player.AbstractClientPlayer player, net.minecraft.world.entity.HumanoidArm arm) {
        if (player.isInvisible()) return;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty() || armor.is(net.minecraft.world.item.Items.AIR) || !(armor.getItem() instanceof net.minecraft.world.item.ArmorItem)) return;

        ResourceLocation itemId = net.minecraft.core.registries.BuiltInRegistries.ITEM.getKey(armor.getItem());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return; // Skip rendering, show normal arm
        }

        playerModel.attackTime = 0.0F;
        playerModel.crouching = false;
        playerModel.swimAmount = 0.0F;
        playerModel.setupAnim(player, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F);

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);

        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, playerModel);
        } else {
            net.minecraft.client.model.HumanoidModel<net.minecraft.world.entity.LivingEntity> armorModel = new net.minecraft.client.model.HumanoidModel<>(
                    net.minecraft.client.model.HumanoidModel.createMesh(new net.minecraft.client.model.geom.builders.CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
            );
            playerModel.copyPropertiesTo(armorModel);
            ModelPart armorArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
            ModelPart playerArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? ((net.minecraft.client.model.PlayerModel<?>) playerModel).leftArm : ((net.minecraft.client.model.PlayerModel<?>) playerModel).rightArm;
            armorArm.copyFrom(playerArm);
            armorArm.xRot = 0.0F;

            net.minecraft.world.item.ArmorItem armorItem = (net.minecraft.world.item.ArmorItem) armor.getItem();
            renderEquipmentLayers(poseStack, buffer, combinedLight, armor, armorItem, armorArm);
            renderArmorTrim(poseStack, buffer, combinedLight, armor, armorItem, armorArm);
            renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(PoseStack matrices, MultiBufferSource vertexConsumers,
                                              int light, ItemStack armor, net.minecraft.world.item.ArmorItem armorItem, ModelPart armorArm) {
        net.minecraft.world.item.ArmorMaterial armorMaterial = armorItem.getMaterial().value();
        if (!armorMaterial.layers().isEmpty()) {
            int dyeColor = armor.is(net.minecraft.tags.ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(armor, 0) : 0;
            boolean hasFoil = armor.hasFoil();

            for (net.minecraft.world.item.ArmorMaterial.Layer layer : armorMaterial.layers()) {
                int color = getColorForLayer(layer, dyeColor, armor);
                if (color != 0) {
                    net.minecraft.resources.ResourceLocation texture = layer.texture(false);
                    VertexConsumer vertexConsumer = net.minecraft.client.renderer.entity.ItemRenderer.getArmorFoilBuffer(vertexConsumers, RenderType.armorCutoutNoCull(texture), hasFoil);
                    armorArm.render(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                    hasFoil = false;
                }
            }
        }
    }

    private static int getColorForLayer(net.minecraft.world.item.ArmorMaterial.Layer layer, int dyeColor, ItemStack armor) {
        var dyeable = layer.dyeable();
        if (dyeable) {
            int defaultColor = net.minecraft.util.FastColor.ARGB32.opaque(net.minecraft.world.item.component.DyedItemColor.getOrDefault(armor, -6265536));
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    private static void renderArmorTrim(PoseStack matrices, MultiBufferSource vertexConsumers,
                                        int light, ItemStack armor, net.minecraft.world.item.ArmorItem armorItem, ModelPart armorArm) {
        net.minecraft.world.item.armortrim.ArmorTrim trim = armor.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            net.minecraft.client.renderer.texture.TextureAtlasSprite sprite = net.minecraft.client.Minecraft.getInstance().getTextureAtlas(net.minecraft.client.renderer.Sheets.ARMOR_TRIMS_SHEET)
                    .apply(trim.outerTexture(armorItem.getMaterial()));
            VertexConsumer trimVertexConsumer = sprite.wrap(
                    vertexConsumers.getBuffer(net.minecraft.client.renderer.Sheets.armorTrimsSheet((trim.pattern().value()).decal())));
            armorArm.render(matrices, trimVertexConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
    *///?}


    //? if 1.21.2 || 1.21.3 {
    /*public static void renderArmor(net.minecraft.client.model.EntityModel entityModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, net.minecraft.world.entity.HumanoidArm arm, boolean isSleeveVisible) {
        net.minecraft.client.player.LocalPlayer player = net.minecraft.client.Minecraft.getInstance().player;
        if (player.isInvisible()) return;
        ItemStack armor = player.getInventory().getArmor(2);
        if (armor.isEmpty() || armor.is(net.minecraft.world.item.Items.AIR) || !(armor.getItem() instanceof net.minecraft.world.item.ArmorItem)) return;

        ResourceLocation itemId = net.minecraft.core.registries.BuiltInRegistries.ITEM.getKey(armor.getItem());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return; // Skip rendering, show normal arm
        }

        net.minecraft.world.item.equipment.Equippable equippable = armor.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);

        net.minecraft.client.model.PlayerModel playerModel = (net.minecraft.client.model.PlayerModel) entityModel;

        ModelPart armModel = arm == net.minecraft.world.entity.HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);

        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (net.minecraft.client.model.HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState>) entityModel);
        } else {
            net.minecraft.client.model.HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel = new net.minecraft.client.model.HumanoidModel<>(
                    net.minecraft.client.model.HumanoidModel.createMesh(new net.minecraft.client.model.geom.builders.CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
            );
            playerModel.copyPropertiesTo(playerModel);

            ModelPart armorArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
            ModelPart playerArm = arm == net.minecraft.world.entity.HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
            armorArm.copyFrom(playerArm);
            armorArm.xRot = 0.0F;

            renderEquipmentLayers(poseStack, buffer, armor, equippable, armorArm, combinedLight);
            renderArmorTrim(poseStack, buffer, armor, equippable, armorArm, combinedLight);
            renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        net.minecraft.resources.ResourceLocation modelId = equippable.model().orElseThrow();
        java.util.List<net.minecraft.world.item.equipment.EquipmentModel.Layer> layers = net.minecraft.client.Minecraft.getInstance().getEquipmentModels().get(modelId).getLayers(net.minecraft.world.item.equipment.EquipmentModel.LayerType.HUMANOID);

        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(net.minecraft.tags.ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(chestplate, 0) : 0;
            boolean hasFoil = chestplate.hasFoil();

            for (net.minecraft.world.item.equipment.EquipmentModel.Layer layer : layers) {
                int color = getColorForLayer(layer, dyeColor);
                if (color != 0) {
                    net.minecraft.resources.ResourceLocation texture = layer.getTextureLocation(net.minecraft.world.item.equipment.EquipmentModel.LayerType.HUMANOID);
                    VertexConsumer vertexConsumer = net.minecraft.client.renderer.entity.ItemRenderer.getArmorFoilBuffer(vertexConsumers, RenderType.armorCutoutNoCull(texture), hasFoil);
                    armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                    hasFoil = false;
                }
            }
        }
    }

    private static int getColorForLayer(net.minecraft.world.item.equipment.EquipmentModel.Layer layer, int dyeColor) {
        var dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = dyeable.get().colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    private static void renderArmorTrim(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        net.minecraft.world.item.equipment.trim.ArmorTrim trim = chestplate.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            net.minecraft.resources.ResourceLocation modelId = equippable.model().orElseThrow();
            net.minecraft.resources.ResourceLocation trimTextureId = trim.getTexture(net.minecraft.world.item.equipment.EquipmentModel.LayerType.HUMANOID, modelId);
            net.minecraft.client.renderer.texture.TextureAtlasSprite trimSprite = net.minecraft.client.Minecraft.getInstance().getTextureAtlas(net.minecraft.client.renderer.Sheets.ARMOR_TRIMS_SHEET).apply(trimTextureId);
            VertexConsumer trimConsumer = trimSprite.wrap(vertexConsumers.getBuffer(net.minecraft.client.renderer.Sheets.armorTrimsSheet(trim.pattern().value().decal())));
            armorArm.render(poseStack, trimConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
    *///?}

    //? if >= 1.21.5 && < 1.21.9 {
    /*public static void renderArmor(EntityModel entityModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, HumanoidArm humanoidArm, boolean isSleeveVisible) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.isEmpty()) return;

        ResourceLocation itemId = net.minecraft.core.registries.BuiltInRegistries.ITEM.getKey(armor.getItem());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return; // Skip rendering, show normal arm
        }

        PlayerModel playerModel = (PlayerModel) entityModel;

        ModelPart armModel = humanoidArm == HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1F;
        playerModel.rightArm.zRot = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, humanoidArm, (HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState>) entityModel);
        } else {
            net.minecraft.world.item.equipment.Equippable equippable = armor.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent() && equippable.slot() == EquipmentSlot.CHEST) {
                renderEquipment(poseStack, buffer, player, humanoidArm, combinedLight, armor);
            }
        }
    }

    @Unique
    private static void renderEquipment(PoseStack poseStack, MultiBufferSource vertexConsumers, LocalPlayer player, HumanoidArm arm, int light, ItemStack chestplate) {
        net.minecraft.world.item.equipment.Equippable equippable = chestplate.get(net.minecraft.core.component.DataComponents.EQUIPPABLE);
        ModelPart armorArm = setupArmorModel(player, arm);
        renderEquipmentLayers(poseStack, vertexConsumers, chestplate, equippable, armorArm, light);
        renderTrim(poseStack, vertexConsumers, chestplate, equippable, armorArm, light);
        renderGlintIfNeeded(poseStack, vertexConsumers, light, chestplate, armorArm);
    }

    @Unique
    private static ModelPart setupArmorModel(LocalPlayer player, HumanoidArm arm) {
        PlayerRenderer playerRenderer = (PlayerRenderer) Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(player);
        PlayerModel playerModel = playerRenderer.getModel();

        HumanoidModel<net.minecraft.client.renderer.entity.state.HumanoidRenderState> armorModel = new HumanoidModel<>(
                HumanoidModel.createMesh(new CubeDeformation(1.0f), 0.0f).getRoot().bake(64, 32)
        );

        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);

        return armorArm;
    }

    @Unique
    private static void renderEquipmentLayers(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> assetId = equippable.assetId().orElseThrow();
        List<net.minecraft.client.resources.model.EquipmentClientInfo.Layer> layers = ((com.github.razorplay01.ismah.common.mixin.EntityRenderDispatcherAccesor) Minecraft.getInstance().getEntityRenderDispatcher())
                .getEquipmentAssetManager()
                .get(assetId)
                .getLayers(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);

        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(ItemTags.DYEABLE) ? net.minecraft.world.item.component.DyedItemColor.getOrDefault(chestplate, 0) : 0;
            boolean hasFoil = chestplate.hasFoil();

            for (net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer : layers) {
                int color = getColorForLayer(layer, dyeColor);
                if (color != 0) {
                    ResourceLocation texture = layer.getTextureLocation(net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID);
                    VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer(vertexConsumers, RenderType.armorCutoutNoCull(texture), hasFoil);
                    armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                    hasFoil = false;
                }
            }
        }
    }

    @Unique
    private static int getColorForLayer(net.minecraft.client.resources.model.EquipmentClientInfo.Layer layer, int dyeColor) {
        var dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = dyeable.get().colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    @Unique
    private static void renderTrim(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, net.minecraft.world.item.equipment.Equippable equippable, ModelPart armorArm, int light) {
        net.minecraft.world.item.equipment.trim.ArmorTrim trim = chestplate.get(net.minecraft.core.component.DataComponents.TRIM);
        if (trim != null) {
            ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> assetId = equippable.assetId().orElseThrow();

            ResourceLocation patternAssetId = trim.pattern().value().assetId();
            String materialSuffix = getColorPaletteSuffix(trim.material(), assetId);
            ResourceLocation trimTextureId = patternAssetId.withPath(p -> "trims/entity/" + net.minecraft.client.resources.model.EquipmentClientInfo.LayerType.HUMANOID.getSerializedName() + "/" + p + "_" + materialSuffix);

            TextureAtlasSprite trimSprite = Minecraft.getInstance().getTextureAtlas(Sheets.ARMOR_TRIMS_SHEET).apply(trimTextureId);
            VertexConsumer trimConsumer = trimSprite.wrap(vertexConsumers.getBuffer(Sheets.armorTrimsSheet(trim.pattern().value().decal())));
            armorArm.render(poseStack, trimConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }

    @Unique
    private static String getColorPaletteSuffix(Holder<net.minecraft.world.item.equipment.trim.TrimMaterial> trimMaterial, ResourceKey<net.minecraft.world.item.equipment.EquipmentAsset> equipmentAsset) {
        net.minecraft.world.item.equipment.trim.MaterialAssetGroup assets = trimMaterial.value().assets();
        net.minecraft.world.item.equipment.trim.MaterialAssetGroup.AssetInfo assetInfo = assets.assetId(equipmentAsset);
        return assetInfo.suffix();
    }
    *///?}

    //? if >= 1.21.9 {
    public static void renderArmor(class_583 entityModel, class_4587 poseStack, class_11659 submitNodeCollector,
                                   int combinedLight, class_1306 humanoidArm, boolean isSleeveVisible) {
        class_746 player = class_310.method_1551().field_1724;
        class_1799 armor = ArmorRendererRegistry.getChestplate(player);
        if (armor.method_7960()) return;

        class_2960 itemId = net.minecraft.class_7923.field_41178.method_10221(armor.method_7909());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return; // Skip rendering, show normal arm
        }

        class_591 playerModel = (class_591) entityModel; // Genérico para 1.21.9

        class_630 armModel = humanoidArm == class_1306.field_6183 ? playerModel.field_3401 : playerModel.field_27433;
        armModel.method_41923();
        armModel.field_3665 = true;
        playerModel.field_3484.field_3665 = isSleeveVisible;
        playerModel.field_3486.field_3665 = isSleeveVisible;
        playerModel.field_27433.field_3674 = -0.1F;
        playerModel.field_3401.field_3674 = 0.1F;

        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, submitNodeCollector, combinedLight, armor, humanoidArm,
                    (class_572<net.minecraft.class_10034>) entityModel);
        } else {
            net.minecraft.class_10192 equippable = armor.method_58694(net.minecraft.class_9334.field_54196);
            if (equippable != null && equippable.comp_3176().isPresent() && equippable.comp_3174() == class_1304.field_6174) {
                renderEquipment(poseStack, submitNodeCollector, player, humanoidArm, combinedLight, armor);
            }
        }
    }

    @Unique
    private static void renderEquipment(class_4587 poseStack, class_11659 submitNodeCollector,
                                        class_746 player, class_1306 arm, int light, class_1799 chestplate) {
        net.minecraft.class_10192 equippable = chestplate.method_58694(net.minecraft.class_9334.field_54196);
        class_630 armorArm = setupArmorModel(player, arm);

        renderEquipmentLayers(poseStack, submitNodeCollector, chestplate, equippable, armorArm, light);
        renderTrim(poseStack, submitNodeCollector, chestplate, equippable, armorArm, light);
        renderGlintIfNeeded(poseStack, submitNodeCollector, light, chestplate, armorArm);
    }

    @Unique
    private static class_630 setupArmorModel(class_746 player, class_1306 arm) {
        class_1007 playerRenderer = (class_1007) class_310.method_1551().method_1561().method_3953(player);
        class_591 playerModel = (class_591) playerRenderer.method_4038();

        class_572 armorModel = new class_572<>(
                class_572.method_32011(new class_5605(1.0f), 0.0f).method_32111().method_32112(64, 32)
        );

        class_630 armorArm = arm == class_1306.field_6182 ? armorModel.field_27433 : armorModel.field_3401;
        class_630 playerArm = arm == class_1306.field_6182 ? playerModel.field_27433 : playerModel.field_3401;
        armorArm.method_32085(playerArm.method_32084());

        return armorArm;
    }

    @Unique
    private static void renderEquipmentLayers(class_4587 poseStack, class_11659 ordered,
                                              class_1799 chestplate, net.minecraft.class_10192 equippable,
                                              class_630 armorArm, int light) {
        class_5321<net.minecraft.class_10394> assetId = equippable.comp_3176().orElseThrow();
        List<net.minecraft.class_10186.class_10189> layers =
                ((com.github.razorplay01.ismah.common.mixin.EntityRenderDispatcherAccesor)
                        class_310.method_1551().method_1561())
                        .getEquipmentAssetManager()
                        .method_64087(assetId)
                        .method_63996(net.minecraft.class_10186.class_10190.field_54125);

        if (!layers.isEmpty()) {
            int dyeColor = chestplate.method_31573(class_3489.field_48803) ? net.minecraft.class_9282.method_57470(chestplate, 0) : 0;

            for (net.minecraft.class_10186.class_10189 layer : layers) {
                int color = getColorForLayer(layer, dyeColor);
                if (color != 0) {
                    class_2960 texture = layer.method_64007(net.minecraft.class_10186.class_10190.field_54125);
                    class_1921 renderType = class_1921.method_25448(texture);

                    // FIX: Params completos + packed color con alpha=255
                    int packedColor = (color & 0xFFFFFF) | 0xFF000000; // Asegura alpha full
                    ordered.method_73494(armorArm, poseStack, renderType, light, class_4608.field_21444,
                            null, // Sprite null
                            false, false, // No cull/flip
                            packedColor, // Tint packed
                            null, // No crumbling
                            0); // Offset 0 para base
                }
            }
        }
    }

    @Unique
    private static int getColorForLayer(net.minecraft.class_10186.class_10189 layer, int dyeColor) {
        var dyeable = layer.comp_3172();
        if (dyeable.isPresent()) {
            int defaultColor = dyeable.get().comp_3170().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? (dyeColor | 0xFF000000) : defaultColor; // FIX: Packed con alpha
        }
        return -1;
    }

    @Unique
    private static void renderTrim(class_4587 poseStack, class_11785 ordered,
                                   class_1799 chestplate, net.minecraft.class_10192 equippable,
                                   class_630 armorArm, int light) {
        net.minecraft.class_8053 trim = chestplate.method_58694(net.minecraft.class_9334.field_49607);
        if (trim != null) {
            class_5321<net.minecraft.class_10394> assetId = equippable.comp_3176().orElseThrow();

            class_2960 patternAssetId = trim.comp_3180().comp_349().comp_1213();
            String materialSuffix = getColorPaletteSuffix(trim.comp_3179(), assetId);
            class_2960 trimTextureId = patternAssetId.method_45134(p ->
                    "trims/entity/" + net.minecraft.class_10186.class_10190.field_54125.method_15434() + "/" + p + "_" + materialSuffix
            );

            // Sprite del trim (igual que antes)
            class_4730 trimMaterial = new class_4730(class_4722.field_42071, trimTextureId);
            class_1058 trimSprite = class_310.method_1551().method_72703().method_73030(trimMaterial);

            // RenderType para el trim (igual que antes)
            class_1921 trimRenderType = class_4722.method_48480(trim.comp_3180().comp_349().comp_1905());
            // Submit el ModelPart (reemplaza render + getBuffer/wrap)
            // Orden implícito en ordered; usa offset 1 si quieres sobre layers
            ordered.method_73494(armorArm, poseStack, trimRenderType, light, class_4608.field_21444,
                    trimSprite, // Sprite para UV/texture mapping
                    false, // bl: No cull (para transparencias en trims)
                    false, // bl2: No flip
                    -1, // k: No tint (trims usan sprite color; ajusta si material tint)
                    null, // CrumblingOverlay: null
                    0); // l: Offset Z=1 para render sobre layers base
        }
    }

    @Unique
    private static String getColorPaletteSuffix(class_6880<net.minecraft.class_8054> trimMaterial,
                                                class_5321<net.minecraft.class_10394> equipmentAsset) {
        net.minecraft.class_10714 assets = trimMaterial.comp_349().comp_3606();
        net.minecraft.class_10714.class_10715 assetInfo = assets.method_67227(equipmentAsset);
        return assetInfo.comp_3605();
    }
    //?}

    //? if >= 1.19.2 && < 1.21.9 {
    /*private static void renderGlintIfNeeded(PoseStack matrices, MultiBufferSource vertexConsumers,
                                            int light, ItemStack armor, ModelPart armorArm) {
        if (armor.hasFoil()) {
            VertexConsumer glintConsumer = vertexConsumers.getBuffer(RenderType.entityGlint());
            armorArm.render(matrices, glintConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
    *///?}
    //? if >= 1.21.9 {
    @Unique
    private static void renderGlintIfNeeded(class_4587 poseStack, class_11659 ordered,
                                            int light, class_1799 armor, class_630 armorArm) {
        if (armor.method_7958()) {
            ordered.method_73491(armorArm, poseStack, class_1921.method_27949(), light, class_4608.field_21444,
                    null);
        }
    }
    //?}
}
