/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.util.LeashRenderer;
import com.github.razorplay01.ismah.client.util.LeashStateAccess;
import com.github.razorplay01.ismah.client.util.LivingEntityRenderStateAccessor;
import com.github.razorplay01.ismah.common.mixin.PlayerModelAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;

public class LeashRenderLayer<T extends PlayerRenderState, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public LeashRenderLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, T entityRenderState, float f, float g) {
        Player player;
        Entity entity = ((LivingEntityRenderStateAccessor)entityRenderState).getEntity();
        if (entity instanceof Player && ((LeashStateAccess)(player = (Player)entity)).getLeashState()) {
            PlayerModel model = (PlayerModel)this.getParentModel();
            boolean isRightArm = ((PlayerRenderState)entityRenderState).mainArm == HumanoidArm.RIGHT;
            boolean isSlim = ((PlayerModelAccessor)model).isSlim();
            ModelPart leash = isRightArm ? (isSlim ? LeashRenderer.RIGHT_LEASH_SLIM : LeashRenderer.RIGHT_LEASH) : (isSlim ? LeashRenderer.LEFT_LEASH_SLIM : LeashRenderer.LEFT_LEASH);
            ModelPart arm = isRightArm ? model.rightArm : model.leftArm;
            LeashRenderer.renderArmLeash(poseStack, multiBufferSource, light, arm, leash);
        }
    }
}

