/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.api.ArmorRendererRegistry;
import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.client.config.ModConfig;
import com.github.razorplay01.ismah.common.mixin.EntityRenderDispatcherAccesor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.MaterialAssetGroup;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.spongepowered.asm.mixin.Unique;

public class RenderUtil {
    private RenderUtil() {
    }

    public static void renderArmor(EntityModel entityModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, HumanoidArm humanoidArm, boolean isSleeveVisible) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack armor = ArmorRendererRegistry.getChestplate((Player)player);
        if (armor.isEmpty()) {
            return;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)armor.getItem());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return;
        }
        PlayerModel playerModel = (PlayerModel)entityModel;
        ModelPart armModel = humanoidArm == HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1f;
        playerModel.rightArm.zRot = 0.1f;
        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, humanoidArm, (HumanoidModel<HumanoidRenderState>)((HumanoidModel)entityModel));
        } else {
            Equippable equippable = (Equippable)armor.get(DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent() && equippable.slot() == EquipmentSlot.CHEST) {
                RenderUtil.renderEquipment(poseStack, buffer, player, humanoidArm, combinedLight, armor);
            }
        }
    }

    @Unique
    private static void renderEquipment(PoseStack poseStack, MultiBufferSource vertexConsumers, LocalPlayer player, HumanoidArm arm, int light, ItemStack chestplate) {
        Equippable equippable = (Equippable)chestplate.get(DataComponents.EQUIPPABLE);
        ModelPart armorArm = RenderUtil.setupArmorModel(player, arm);
        RenderUtil.renderEquipmentLayers(poseStack, vertexConsumers, chestplate, equippable, armorArm, light);
        RenderUtil.renderTrim(poseStack, vertexConsumers, chestplate, equippable, armorArm, light);
        RenderUtil.renderGlintIfNeeded(poseStack, vertexConsumers, light, chestplate, armorArm);
    }

    @Unique
    private static ModelPart setupArmorModel(LocalPlayer player, HumanoidArm arm) {
        PlayerRenderer playerRenderer = (PlayerRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)player);
        PlayerModel playerModel = (PlayerModel)playerRenderer.getModel();
        HumanoidModel armorModel = new HumanoidModel(HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f).getRoot().bake(64, 32));
        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.copyFrom(playerArm);
        return armorArm;
    }

    @Unique
    private static void renderEquipmentLayers(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, Equippable equippable, ModelPart armorArm, int light) {
        ResourceKey assetId = (ResourceKey)equippable.assetId().orElseThrow();
        List layers = ((EntityRenderDispatcherAccesor)Minecraft.getInstance().getEntityRenderDispatcher()).getEquipmentAssetManager().get(assetId).getLayers(EquipmentClientInfo.LayerType.HUMANOID);
        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)chestplate, (int)0) : 0;
            boolean hasFoil = chestplate.hasFoil();
            for (EquipmentClientInfo.Layer layer : layers) {
                int color = RenderUtil.getColorForLayer(layer, dyeColor);
                if (color == 0) continue;
                ResourceLocation texture = layer.getTextureLocation(EquipmentClientInfo.LayerType.HUMANOID);
                VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)vertexConsumers, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)texture), (boolean)hasFoil);
                armorArm.render(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY, color);
                hasFoil = false;
            }
        }
    }

    @Unique
    private static int getColorForLayer(EquipmentClientInfo.Layer layer, int dyeColor) {
        Optional dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = ((EquipmentClientInfo.Dyeable)dyeable.get()).colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor : defaultColor;
        }
        return -1;
    }

    @Unique
    private static void renderTrim(PoseStack poseStack, MultiBufferSource vertexConsumers, ItemStack chestplate, Equippable equippable, ModelPart armorArm, int light) {
        ArmorTrim trim = (ArmorTrim)chestplate.get(DataComponents.TRIM);
        if (trim != null) {
            ResourceKey assetId = (ResourceKey)equippable.assetId().orElseThrow();
            ResourceLocation patternAssetId = ((TrimPattern)trim.pattern().value()).assetId();
            String materialSuffix = RenderUtil.getColorPaletteSuffix((Holder<TrimMaterial>)trim.material(), (ResourceKey<EquipmentAsset>)assetId);
            ResourceLocation trimTextureId = patternAssetId.withPath(p -> "trims/entity/" + EquipmentClientInfo.LayerType.HUMANOID.getSerializedName() + "/" + p + "_" + materialSuffix);
            TextureAtlasSprite trimSprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(Sheets.ARMOR_TRIMS_SHEET).apply(trimTextureId);
            VertexConsumer trimConsumer = trimSprite.wrap(vertexConsumers.getBuffer(Sheets.armorTrimsSheet((boolean)((TrimPattern)trim.pattern().value()).decal())));
            armorArm.render(poseStack, trimConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }

    @Unique
    private static String getColorPaletteSuffix(Holder<TrimMaterial> trimMaterial, ResourceKey<EquipmentAsset> equipmentAsset) {
        MaterialAssetGroup assets = ((TrimMaterial)trimMaterial.value()).assets();
        MaterialAssetGroup.AssetInfo assetInfo = assets.assetId(equipmentAsset);
        return assetInfo.suffix();
    }

    private static void renderGlintIfNeeded(PoseStack matrices, MultiBufferSource vertexConsumers, int light, ItemStack armor, ModelPart armorArm) {
        if (armor.hasFoil()) {
            VertexConsumer glintConsumer = vertexConsumers.getBuffer(RenderType.entityGlint());
            armorArm.render(matrices, glintConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
}

