/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.neoforge.screen;

import com.github.razorplay01.ismah.client.config.ModConfig;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BlacklistConfigScreen
extends Screen {
    private final Screen parent;
    private BlacklistListWidget list;
    private EditBox addField;

    public BlacklistConfigScreen(Screen parent) {
        super((Component)Component.literal((String)"ISMAH Configuration"));
        this.parent = parent;
    }

    protected void init() {
        this.list = new BlacklistListWidget(this.minecraft);
        this.addRenderableWidget((GuiEventListener)this.list);
        this.addField = new EditBox(this.font, this.width / 2 - 100, this.height - 60, 150, 20, (Component)Component.literal((String)"Add Armor ID"));
        this.addField.setMaxLength(128);
        this.addRenderableWidget((GuiEventListener)this.addField);
        Button addButton = Button.builder((Component)Component.literal((String)"Add"), button -> this.addEntry()).bounds(this.width / 2 + 55, this.height - 60, 45, 20).build();
        this.addRenderableWidget((GuiEventListener)addButton);
        Button doneButton = Button.builder((Component)Component.literal((String)"Done"), button -> this.onClose()).bounds(this.width / 2 - 100, this.height - 30, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)doneButton);
    }

    private void addEntry() {
        String id = this.addField.getValue().trim();
        if (!id.isEmpty()) {
            try {
                ResourceLocation.parse((String)id);
                ModConfig.addBlacklistedArmor(id);
                this.list.refreshEntries();
                this.addField.setValue("");
            }
            catch (Exception e) {
                this.addField.setValue("");
            }
        }
    }

    public void onClose() {
        ModConfig.saveConfig();
        this.minecraft.setScreen(this.parent);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.list.render(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        super.render(context, mouseX, mouseY, delta);
    }

    public class BlacklistListWidget
    extends AbstractSelectionList<Entry> {
        public BlacklistListWidget(Minecraft client) {
            super(client, BlacklistConfigScreen.this.width, BlacklistConfigScreen.this.height - 95, 32, 25);
            this.refreshEntries();
        }

        public void refreshEntries() {
            this.clearEntries();
            for (String id : ModConfig.getBlacklistedArmors()) {
                this.addEntry(new Entry(id));
            }
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public class Entry
        extends AbstractSelectionList.Entry<Entry> {
            private final String id;
            private final Button removeButton;

            public Entry(String id) {
                this.id = id;
                this.removeButton = Button.builder((Component)Component.literal((String)"Remove"), button -> {
                    ModConfig.removeBlacklistedArmor(this.id);
                    BlacklistListWidget.this.refreshEntries();
                }).bounds(0, 0, 60, 20).build();
            }

            public void render(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                int textX = x + 5;
                Objects.requireNonNull(BlacklistConfigScreen.this.font);
                int textY = y + (entryHeight - 9) / 2 + 1;
                guiGraphics.drawString(BlacklistConfigScreen.this.font, this.id, textX, textY, 0xFFFFFF, true);
                this.removeButton.setX(x + entryWidth - 65);
                this.removeButton.setY(y);
                this.removeButton.render(guiGraphics, mouseX, mouseY, tickDelta);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                return this.removeButton.mouseClicked(mouseX, mouseY, button) || super.mouseClicked(mouseX, mouseY, button);
            }

            public boolean mouseReleased(double mouseX, double mouseY, int button) {
                return this.removeButton.mouseReleased(mouseX, mouseY, button) || super.mouseReleased(mouseX, mouseY, button);
            }
        }
    }
}

