/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<String> blacklistedArmors = new HashSet<String>();

    private ModConfig() {
    }

    private static File getConfigFile() {
        return new File(Minecraft.m_91087_().f_91069_, "config/ismah.json");
    }

    public static void loadConfig() {
        File configFile = ModConfig.getConfigFile();
        if (!configFile.exists()) {
            ModConfig.saveConfig();
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            blacklistedArmors.clear();
            GsonHelper.m_13832_((JsonObject)json, (String)"blacklisted_armors", null).forEach(element -> {
                if (element.isJsonPrimitive()) {
                    blacklistedArmors.add(element.getAsString());
                }
            });
            LOGGER.info("Loaded {} blacklisted armors from config.", (Object)blacklistedArmors.size());
        }
        catch (IOException | IllegalStateException e) {
            LOGGER.error("Failed to load config: {}", (Object)e.getMessage());
            ModConfig.saveConfig();
        }
    }

    public static void saveConfig() {
        File configFile = ModConfig.getConfigFile();
        JsonObject json = new JsonObject();
        json.add("blacklisted_armors", GSON.toJsonTree((Object)blacklistedArmors.toArray(new String[0])));
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config: {}", (Object)e.getMessage());
        }
    }

    public static boolean isArmorBlacklisted(ResourceLocation itemId) {
        return blacklistedArmors.contains(itemId.toString());
    }

    public static Set<String> getBlacklistedArmors() {
        return Collections.unmodifiableSet(blacklistedArmors);
    }

    public static void addBlacklistedArmor(String id) {
        blacklistedArmors.add(id);
    }

    public static void removeBlacklistedArmor(String id) {
        blacklistedArmors.remove(id);
    }
}

