/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.api.ArmorRendererRegistry;
import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.client.config.ModConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class RenderUtil {
    private RenderUtil() {
    }

    public static void renderArmor(PlayerModel playerModel, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, HumanoidArm arm) {
        if (player.m_20145_()) {
            return;
        }
        ItemStack armor = ArmorRendererRegistry.getChestplate((Player)player);
        if (armor.m_41619_() || armor.m_150930_(Items.f_41852_) || !(armor.m_41720_() instanceof ArmorItem)) {
            return;
        }
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)armor.m_41720_());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return;
        }
        ModelPart armModel = arm == HumanoidArm.RIGHT ? playerModel.f_102811_ : playerModel.f_102812_;
        armModel.m_233569_();
        armModel.f_104207_ = true;
        playerModel.f_102812_.f_104205_ = -0.1f;
        playerModel.f_102811_.f_104205_ = 0.1f;
        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, buffer, combinedLight, armor, arm, (HumanoidModel<LivingEntity>)playerModel);
        } else {
            HumanoidModel armorModel = new HumanoidModel(HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f).m_171576_().m_171583_(64, 32));
            playerModel.m_102872_((HumanoidModel)playerModel);
            ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.f_102812_ : armorModel.f_102811_;
            ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.f_102812_ : playerModel.f_102811_;
            armorArm.m_104315_(playerArm);
            armorArm.f_104203_ = 0.0f;
            RenderUtil.renderEquipmentLayers(poseStack, buffer, combinedLight, armor, armorArm);
            RenderUtil.renderGlintIfNeeded(poseStack, buffer, combinedLight, armor, armorArm);
        }
    }

    private static void renderEquipmentLayers(PoseStack matrices, MultiBufferSource vertexConsumers, int light, ItemStack armor, ModelPart armorArm) {
        ArmorItem armorItem = (ArmorItem)armor.m_41720_();
        if (armorItem instanceof DyeableArmorItem) {
            DyeableArmorItem dyeableArmorItem = (DyeableArmorItem)armorItem;
            int color = dyeableArmorItem.m_41121_(armor);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            RenderUtil.renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, r, g, b, null);
            RenderUtil.renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0f, 1.0f, 1.0f, "overlay");
        } else {
            RenderUtil.renderArmorLayer(matrices, vertexConsumers, light, armorItem, armorArm, 1.0f, 1.0f, 1.0f, null);
        }
    }

    private static void renderArmorLayer(PoseStack matrices, MultiBufferSource vertexConsumers, int light, ArmorItem armorItem, ModelPart armorPart, float r, float g, float b, String overlay) {
        ResourceLocation armorTexture = RenderUtil.getArmorTexture(armorItem, overlay);
        VertexConsumer vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110431_((ResourceLocation)armorTexture));
        armorPart.m_104306_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
    }

    private static ResourceLocation getArmorTexture(ArmorItem armorItem, String overlay) {
        String materialName = armorItem.m_40401_().m_6082_();
        String namespace = "minecraft";
        String baseName = materialName;
        if (materialName.contains(":")) {
            String[] parts = materialName.split(":", 2);
            namespace = parts[0];
            baseName = parts[1];
        }
        String path = "textures/models/armor/" + baseName + "_layer_1" + (String)(overlay == null ? "" : "_" + overlay) + ".png";
        return new ResourceLocation(namespace, path);
    }

    private static void renderGlintIfNeeded(PoseStack matrices, MultiBufferSource vertexConsumers, int light, ItemStack armor, ModelPart armorArm) {
        if (armor.m_41790_()) {
            VertexConsumer glintConsumer = vertexConsumers.m_6299_(RenderType.m_110496_());
            armorArm.m_104301_(matrices, glintConsumer, light, OverlayTexture.f_118083_);
        }
    }
}

