/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.api;

import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.common.mixin.InventoryAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;

public class ArmorRendererRegistry {
    private static final List<CustomArmorRenderer> renderers = new ArrayList<CustomArmorRenderer>();
    private static final List<Function<Player, ItemStack>> chestplateProviders = new ArrayList<Function<Player, ItemStack>>();

    private ArmorRendererRegistry() {
    }

    public static void register(CustomArmorRenderer renderer) {
        renderers.add(renderer);
    }

    public static CustomArmorRenderer getRenderer(ItemStack stack) {
        for (CustomArmorRenderer renderer : renderers) {
            if (!renderer.canRender(stack)) continue;
            return renderer;
        }
        return null;
    }

    public static void registerChestplateProvider(Function<Player, ItemStack> provider) {
        chestplateProviders.add(provider);
    }

    public static ItemStack getChestplate(Player player) {
        for (Function<Player, ItemStack> provider : chestplateProviders) {
            Equippable equippable;
            ItemStack stack = provider.apply(player);
            if (stack == null || stack.isEmpty() || (equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE)).slot() != EquipmentSlot.CHEST) continue;
            return stack;
        }
        return ((InventoryAccessor)player.getInventory()).getEquipment().get(EquipmentSlot.CHEST);
    }
}

