/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.client.util;

import com.github.razorplay01.ismah.client.api.ArmorRendererRegistry;
import com.github.razorplay01.ismah.client.api.CustomArmorRenderer;
import com.github.razorplay01.ismah.client.config.ModConfig;
import com.github.razorplay01.ismah.common.mixin.EntityRenderDispatcherAccesor;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.OrderedSubmitNodeCollector;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.MaterialAssetGroup;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import org.spongepowered.asm.mixin.Unique;

public class RenderUtil {
    private RenderUtil() {
    }

    public static void renderArmor(EntityModel entityModel, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int combinedLight, HumanoidArm humanoidArm, boolean isSleeveVisible) {
        LocalPlayer player = Minecraft.getInstance().player;
        ItemStack armor = ArmorRendererRegistry.getChestplate((Player)player);
        if (armor.isEmpty()) {
            return;
        }
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)armor.getItem());
        if (ModConfig.isArmorBlacklisted(itemId)) {
            return;
        }
        PlayerModel playerModel = (PlayerModel)entityModel;
        ModelPart armModel = humanoidArm == HumanoidArm.RIGHT ? playerModel.rightArm : playerModel.leftArm;
        armModel.resetPose();
        armModel.visible = true;
        playerModel.leftSleeve.visible = isSleeveVisible;
        playerModel.rightSleeve.visible = isSleeveVisible;
        playerModel.leftArm.zRot = -0.1f;
        playerModel.rightArm.zRot = 0.1f;
        CustomArmorRenderer customRenderer = ArmorRendererRegistry.getRenderer(armor);
        if (customRenderer != null) {
            customRenderer.render(poseStack, submitNodeCollector, combinedLight, armor, humanoidArm, (HumanoidModel<HumanoidRenderState>)((HumanoidModel)entityModel));
        } else {
            Equippable equippable = (Equippable)armor.get(DataComponents.EQUIPPABLE);
            if (equippable != null && equippable.assetId().isPresent() && equippable.slot() == EquipmentSlot.CHEST) {
                RenderUtil.renderEquipment(poseStack, submitNodeCollector, player, humanoidArm, combinedLight, armor);
            }
        }
    }

    @Unique
    private static void renderEquipment(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, LocalPlayer player, HumanoidArm arm, int light, ItemStack chestplate) {
        Equippable equippable = (Equippable)chestplate.get(DataComponents.EQUIPPABLE);
        ModelPart armorArm = RenderUtil.setupArmorModel(player, arm);
        RenderUtil.renderEquipmentLayers(poseStack, submitNodeCollector, chestplate, equippable, armorArm, light);
        RenderUtil.renderTrim(poseStack, (OrderedSubmitNodeCollector)submitNodeCollector, chestplate, equippable, armorArm, light);
        RenderUtil.renderGlintIfNeeded(poseStack, submitNodeCollector, light, chestplate, armorArm);
    }

    @Unique
    private static ModelPart setupArmorModel(LocalPlayer player, HumanoidArm arm) {
        AvatarRenderer playerRenderer = (AvatarRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)player);
        PlayerModel playerModel = (PlayerModel)playerRenderer.getModel();
        HumanoidModel armorModel = new HumanoidModel(HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(1.0f), (float)0.0f).getRoot().bake(64, 32));
        ModelPart armorArm = arm == HumanoidArm.LEFT ? armorModel.leftArm : armorModel.rightArm;
        ModelPart playerArm = arm == HumanoidArm.LEFT ? playerModel.leftArm : playerModel.rightArm;
        armorArm.loadPose(playerArm.storePose());
        return armorArm;
    }

    @Unique
    private static void renderEquipmentLayers(PoseStack poseStack, SubmitNodeCollector ordered, ItemStack chestplate, Equippable equippable, ModelPart armorArm, int light) {
        ResourceKey assetId = (ResourceKey)equippable.assetId().orElseThrow();
        List layers = ((EntityRenderDispatcherAccesor)Minecraft.getInstance().getEntityRenderDispatcher()).getEquipmentAssetManager().get(assetId).getLayers(EquipmentClientInfo.LayerType.HUMANOID);
        if (!layers.isEmpty()) {
            int dyeColor = chestplate.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)chestplate, (int)0) : 0;
            for (EquipmentClientInfo.Layer layer : layers) {
                int color = RenderUtil.getColorForLayer(layer, dyeColor);
                if (color == 0) continue;
                ResourceLocation texture = layer.getTextureLocation(EquipmentClientInfo.LayerType.HUMANOID);
                RenderType renderType = RenderType.armorCutoutNoCull((ResourceLocation)texture);
                int packedColor = color & 0xFFFFFF | 0xFF000000;
                ordered.submitModelPart(armorArm, poseStack, renderType, light, OverlayTexture.NO_OVERLAY, null, false, false, packedColor, null, 0);
            }
        }
    }

    @Unique
    private static int getColorForLayer(EquipmentClientInfo.Layer layer, int dyeColor) {
        Optional dyeable = layer.dyeable();
        if (dyeable.isPresent()) {
            int defaultColor = ((EquipmentClientInfo.Dyeable)dyeable.get()).colorWhenUndyed().map(color -> 0xFF000000 | color).orElse(0);
            return dyeColor != 0 ? dyeColor | 0xFF000000 : defaultColor;
        }
        return -1;
    }

    @Unique
    private static void renderTrim(PoseStack poseStack, OrderedSubmitNodeCollector ordered, ItemStack chestplate, Equippable equippable, ModelPart armorArm, int light) {
        ArmorTrim trim = (ArmorTrim)chestplate.get(DataComponents.TRIM);
        if (trim != null) {
            ResourceKey assetId = (ResourceKey)equippable.assetId().orElseThrow();
            ResourceLocation patternAssetId = ((TrimPattern)trim.pattern().value()).assetId();
            String materialSuffix = RenderUtil.getColorPaletteSuffix((Holder<TrimMaterial>)trim.material(), (ResourceKey<EquipmentAsset>)assetId);
            ResourceLocation trimTextureId = patternAssetId.withPath(p -> "trims/entity/" + EquipmentClientInfo.LayerType.HUMANOID.getSerializedName() + "/" + p + "_" + materialSuffix);
            Material trimMaterial = new Material(Sheets.ARMOR_TRIMS_SHEET, trimTextureId);
            TextureAtlasSprite trimSprite = Minecraft.getInstance().getAtlasManager().get(trimMaterial);
            RenderType trimRenderType = Sheets.armorTrimsSheet((boolean)((TrimPattern)trim.pattern().value()).decal());
            ordered.submitModelPart(armorArm, poseStack, trimRenderType, light, OverlayTexture.NO_OVERLAY, trimSprite, false, false, -1, null, 0);
        }
    }

    @Unique
    private static String getColorPaletteSuffix(Holder<TrimMaterial> trimMaterial, ResourceKey<EquipmentAsset> equipmentAsset) {
        MaterialAssetGroup assets = ((TrimMaterial)trimMaterial.value()).assets();
        MaterialAssetGroup.AssetInfo assetInfo = assets.assetId(equipmentAsset);
        return assetInfo.suffix();
    }

    @Unique
    private static void renderGlintIfNeeded(PoseStack poseStack, SubmitNodeCollector ordered, int light, ItemStack armor, ModelPart armorArm) {
        if (armor.hasFoil()) {
            ordered.submitModelPart(armorArm, poseStack, RenderType.armorEntityGlint(), light, OverlayTexture.NO_OVERLAY, null);
        }
    }
}

