/*
 * Decompiled with CFR 0.152.
 */
package com.github.razorplay01.ismah.common.mixin.leash;

import com.github.razorplay01.ismah.client.util.LeashStateAccess;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class LeashAttachMixin {
    @Shadow
    private ClientLevel level;

    @Inject(method={"handleEntityLinkPacket(Lnet/minecraft/network/protocol/game/ClientboundSetEntityLinkPacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Leashable;setDelayedLeashHolderId(I)V")})
    private void onEntityAttach(ClientboundSetEntityLinkPacket clientboundSetEntityLinkPacket, CallbackInfo ci) {
        Entity entity1 = this.level.getEntity(clientboundSetEntityLinkPacket.getSourceId());
        if (entity1 instanceof Leashable) {
            Leashable target = (Leashable)entity1;
            Entity currentLeashHolder = this.getLeashHolder(target);
            if (clientboundSetEntityLinkPacket.getDestId() == 0) {
                if (currentLeashHolder instanceof AbstractClientPlayer) {
                    AbstractClientPlayer player = (AbstractClientPlayer)currentLeashHolder;
                    AABB box = new AABB(player.getX() - 16.0, player.getY() - 16.0, player.getZ() - 16.0, player.getX() + 16.0, player.getY() + 16.0, player.getZ() + 16.0);
                    List nearby = player.level().getEntitiesOfClass(Entity.class, box);
                    boolean hasOtherLeashedEntities = false;
                    for (Entity entity : nearby) {
                        Leashable leashable;
                        if (!(entity instanceof Leashable) || (leashable = (Leashable)entity) == target || this.getLeashHolder(leashable) != player) continue;
                        hasOtherLeashedEntities = true;
                        break;
                    }
                    if (!hasOtherLeashedEntities) {
                        ((LeashStateAccess)player).setLeashState(false);
                    }
                }
            } else {
                Entity newLeashHolder = this.level.getEntity(clientboundSetEntityLinkPacket.getDestId());
                if (newLeashHolder instanceof LeashStateAccess) {
                    LeashStateAccess player = (LeashStateAccess)newLeashHolder;
                    player.setLeashState(true);
                } else if (currentLeashHolder instanceof AbstractClientPlayer) {
                    AbstractClientPlayer player = (AbstractClientPlayer)currentLeashHolder;
                    AABB box = new AABB(player.getX() - 16.0, player.getY() - 16.0, player.getZ() - 16.0, player.getX() + 16.0, player.getY() + 16.0, player.getZ() + 16.0);
                    List nearby = player.level().getEntitiesOfClass(Entity.class, box);
                    boolean hasOtherLeashedEntities = false;
                    for (Entity entity : nearby) {
                        Leashable leashable;
                        if (!(entity instanceof Leashable) || (leashable = (Leashable)entity) == target || this.getLeashHolder(leashable) != player) continue;
                        hasOtherLeashedEntities = true;
                        break;
                    }
                    if (!hasOtherLeashedEntities) {
                        ((LeashStateAccess)player).setLeashState(false);
                    }
                }
            }
        }
    }

    @Unique
    private Entity getLeashHolder(Leashable leashable) {
        return leashable.getLeashHolder();
    }
}

