/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.crosshair.style.CrosshairStyleFactory;
import com.wjbaker.ccm.crosshair.style.ICrosshairStyle;
import com.wjbaker.ccm.render.ModTheme;
import com.wjbaker.ccm.render.RenderManager;
import com.wjbaker.ccm.type.RGBA;
import java.util.Set;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class CrosshairRenderManager {
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private final boolean isForGui;
    private final RenderManager renderManager;
    private final CrosshairStyleFactory crosshairStyleFactory;
    private final Set<Item> itemCooldownItems = ImmutableSet.of((Object)Items.f_42584_, (Object)Items.f_42730_);

    public CrosshairRenderManager(boolean isForGui) {
        this.isForGui = isForGui;
        this.renderManager = new RenderManager();
        this.crosshairStyleFactory = new CrosshairStyleFactory();
    }

    public void draw(CustomCrosshair crosshair, int x, int y) {
        ComputedProperties computedProperties = new ComputedProperties(crosshair);
        if (!computedProperties.isVisible()) {
            return;
        }
        GuiGraphics guiGraphics = new GuiGraphics(Minecraft.m_91087_(), Minecraft.m_91087_().m_91269_().m_110104_());
        MinecraftForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Pre(Minecraft.m_91087_().m_91268_(), guiGraphics, 1.0f, VanillaGuiOverlay.CROSSHAIR.type()));
        CrosshairStyle calculatedStyle = Minecraft.m_91087_().f_91066_.f_92063_ && (Boolean)crosshair.isKeepDebugEnabled.get() != false ? CrosshairStyle.DEBUG : (CrosshairStyle)((Object)crosshair.style.get());
        ICrosshairStyle style = this.crosshairStyleFactory.from(calculatedStyle, crosshair);
        Boolean isItemCooldownEnabled = (Boolean)crosshair.isItemCooldownEnabled.get();
        Boolean isDotEnabled = (Boolean)crosshair.isDotEnabled.get();
        PoseStack transformMatrixStack = calculatedStyle == CrosshairStyle.DEBUG ? RenderSystem.getModelViewStack() : guiGraphics.m_280168_();
        int renderX = x + (Integer)crosshair.offsetX.get();
        int renderY = y + (Integer)crosshair.offsetY.get();
        this.preTransformation(transformMatrixStack, crosshair, renderX, renderY);
        this.drawToolDamageIndicator(guiGraphics, crosshair, computedProperties, renderX, renderY);
        this.drawDefaultAttackIndicator(guiGraphics, computedProperties, 0, 0);
        if (isDotEnabled.booleanValue() && crosshair.style.get() != CrosshairStyle.DEFAULT) {
            this.renderManager.drawCircle(guiGraphics.m_280168_(), 0.0f, 0.0f, 0.5f, 1.0f, (RGBA)crosshair.dotColour.get());
        }
        if (isItemCooldownEnabled.booleanValue()) {
            this.drawItemCooldownIndicator(guiGraphics.m_280168_(), crosshair, computedProperties, 0, 0);
        }
        style.draw(guiGraphics, 0, 0, computedProperties);
        this.postTransformation(transformMatrixStack);
        MinecraftForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Post(Minecraft.m_91087_().m_91268_(), guiGraphics, 1.0f, VanillaGuiOverlay.CROSSHAIR.type()));
    }

    private void preTransformation(PoseStack matrixStack, CustomCrosshair crosshair, int x, int y) {
        Integer rotation = (Integer)crosshair.rotation.get();
        int scale = (Integer)crosshair.scale.get() - 2;
        float windowScaling = (float)Minecraft.m_91087_().m_91268_().m_85449_() / 2.0f;
        float z = this.isForGui ? 0.0f : 1000.0f - ForgeHooksClient.getGuiFarPlane();
        matrixStack.m_85836_();
        matrixStack.m_252880_((float)x, (float)y, z);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_((float)rotation.intValue()));
        matrixStack.m_85841_((float)scale / 100.0f / windowScaling, (float)scale / 100.0f / windowScaling, 1.0f);
        RenderSystem.applyModelViewMatrix();
    }

    private void postTransformation(PoseStack matrixStack) {
        matrixStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    private void drawItemCooldownIndicator(PoseStack matrixStack, CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        RGBA colour = (RGBA)crosshair.itemCooldownColour.get();
        Integer width = (Integer)crosshair.width.get();
        Integer height = (Integer)crosshair.height.get();
        int maxSize = Math.max(width, height);
        int offset = 3;
        for (Item item : this.itemCooldownItems) {
            float cooldown = player.m_36335_().m_41521_(item, 0.0f);
            if (cooldown == 0.0f) continue;
            int progress = Math.round(360.0f - 360.0f * cooldown);
            this.renderManager.drawPartialCircle(matrixStack, x, y, computedProperties.gap() + maxSize + offset, 0, progress, 2.0f, colour);
            offset += 3;
        }
    }

    private void drawDefaultAttackIndicator(GuiGraphics guiGraphics, ComputedProperties computedProperties, int x, int y) {
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.m_232120_().m_231551_() == AttackIndicatorStatus.CROSSHAIR && mc.f_91074_ != null) {
            float f = mc.f_91074_.m_36403_(0.0f);
            boolean flag = false;
            if (mc.f_91076_ instanceof LivingEntity && f < 1.0f) {
                flag = mc.f_91074_.m_36333_() > 5.0f;
                flag &= mc.f_91076_.m_6084_();
            }
            int drawX = x - 8;
            int drawY = y - 7 + 16;
            if (flag) {
                guiGraphics.m_280398_(GUI_ICONS_LOCATION, drawX, drawY, 0, 68.0f, 94.0f, 16, 16, 256, 256);
            } else if (f < 1.0f) {
                int l = (int)(f * 17.0f);
                guiGraphics.m_280398_(GUI_ICONS_LOCATION, drawX, drawY, 0, 36.0f, 94.0f, 16, 4, 256, 256);
                guiGraphics.m_280398_(GUI_ICONS_LOCATION, drawX, drawY, 0, 52.0f, 94.0f, l, 4, 256, 256);
            }
        }
    }

    private void drawToolDamageIndicator(GuiGraphics guiGraphics, CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        if (!((Boolean)crosshair.isToolDamageEnabled.get()).booleanValue()) {
            return;
        }
        int drawX = x + (Integer)crosshair.gap.get() + 5;
        int drawY = y + (Integer)crosshair.gap.get() + 5;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        ItemStack tool = mc.f_91074_.m_21205_();
        if (!tool.m_41763_()) {
            return;
        }
        int remainingDamage = tool.m_41776_() - tool.m_41773_();
        if (remainingDamage > 10) {
            return;
        }
        ItemRenderer itemRenderer = mc.m_91291_();
        BakedModel model = itemRenderer.m_174264_(tool, null, null, 0);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(8.0, 8.0, 0.0);
        matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
        matrixStack.m_85841_(8.0f, 8.0f, 8.0f);
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84930_();
        itemRenderer.m_115143_(tool, ItemDisplayContext.GUI, false, guiGraphics.m_280168_(), (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, model);
        guiGraphics.m_280091_().m_109911_();
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
        matrixStack.m_85849_();
        this.renderManager.drawSmallText(guiGraphics, "" + remainingDamage, drawX + 6 - x, drawY - y, ModTheme.WHITE, true);
    }
}

