/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.style.styles;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.AbstractCrosshairStyle;
import com.wjbaker.ccm.type.RGBA;
import net.minecraft.client.gui.GuiGraphics;

public final class CrossStyle
extends AbstractCrosshairStyle {
    public CrossStyle(CustomCrosshair crosshair) {
        super(crosshair);
    }

    @Override
    public void draw(GuiGraphics guiGraphics, int x, int y, ComputedProperties computedProperties) {
        boolean isOutlineEnabled = (Boolean)this.crosshair.isOutlineEnabled.get();
        RGBA baseColour = computedProperties.colour();
        int gap = computedProperties.gap();
        float thickness = ((Integer)this.crosshair.thickness.get()).intValue();
        int width = (Integer)this.crosshair.width.get();
        int height = (Integer)this.crosshair.height.get();
        Boolean isAdaptiveColourEnabled = (Boolean)this.crosshair.isAdaptiveColourEnabled.get();
        if (isOutlineEnabled) {
            RGBA outlineColour = (RGBA)this.crosshair.outlineColour.get();
            float adjustedWidth = (float)width + 1.0f;
            float adjustedHeight = (float)height + 1.0f;
            float adjustedGap = (float)gap - 0.5f;
            this.renderManager.drawBorderedRectangle(guiGraphics.m_280168_(), (float)x - thickness, (float)y - adjustedGap - adjustedHeight, (float)x + thickness, (float)y - adjustedGap, 2.0f, outlineColour, baseColour, isAdaptiveColourEnabled);
            this.renderManager.drawBorderedRectangle(guiGraphics.m_280168_(), (float)x - thickness, (float)y + adjustedGap, (float)x + thickness, (float)y + adjustedGap + adjustedHeight, 2.0f, outlineColour, baseColour, isAdaptiveColourEnabled);
            this.renderManager.drawBorderedRectangle(guiGraphics.m_280168_(), (float)x - adjustedGap - adjustedWidth, (float)y - thickness, (float)x - adjustedGap, (float)y + thickness, 2.0f, outlineColour, baseColour, isAdaptiveColourEnabled);
            this.renderManager.drawBorderedRectangle(guiGraphics.m_280168_(), (float)x + adjustedGap, (float)y - thickness, (float)x + adjustedGap + adjustedWidth, (float)y + thickness, 2.0f, outlineColour, baseColour, isAdaptiveColourEnabled);
        } else {
            float adjustedThickness = thickness - 0.5f;
            this.renderManager.drawFilledRectangle(guiGraphics.m_280168_(), (float)x - adjustedThickness, y - gap - height, (float)x + adjustedThickness, y - gap, baseColour, isAdaptiveColourEnabled);
            this.renderManager.drawFilledRectangle(guiGraphics.m_280168_(), (float)x - adjustedThickness, y + gap, (float)x + adjustedThickness, y + gap + height, baseColour, isAdaptiveColourEnabled);
            this.renderManager.drawFilledRectangle(guiGraphics.m_280168_(), x - gap - width, (float)y - adjustedThickness, x - gap, (float)y + adjustedThickness, baseColour, isAdaptiveColourEnabled);
            this.renderManager.drawFilledRectangle(guiGraphics.m_280168_(), x + gap, (float)y - adjustedThickness, x + gap + width, (float)y + adjustedThickness, baseColour, isAdaptiveColourEnabled);
        }
    }
}

