/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.render.gui.component.components;

import com.wjbaker.ccm.crosshair.property.EnumProperty;
import com.wjbaker.ccm.render.ModTheme;
import com.wjbaker.ccm.render.gui.component.components.SliderGuiComponent;
import com.wjbaker.ccm.render.gui.component.type.IBindableGuiComponent;
import com.wjbaker.ccm.render.gui.screen.GuiScreen;
import net.minecraft.client.gui.GuiGraphics;
import org.apache.commons.lang3.StringUtils;

public final class EnumSliderGuiComponent<TEnum extends Enum<TEnum>>
extends SliderGuiComponent
implements IBindableGuiComponent<EnumProperty<TEnum>> {
    private EnumProperty<TEnum> value;

    public EnumSliderGuiComponent(GuiScreen parentGuiScreen, int x, int y, int width, String label, TEnum defaultValue) {
        super(parentGuiScreen, x, y, width, label, 0, ((Enum[])defaultValue.getClass().getEnumConstants()).length - 1, -1);
        this.value = new EnumProperty<TEnum>("fake_value", defaultValue);
        this.thumbPosition = (((Enum)this.value.get()).ordinal() - this.minValue) * (this.width - this.thumbSize) / (this.maxValue - this.minValue);
    }

    @Override
    protected void calculateValue() {
        float positionRatio = (float)this.thumbPosition / (float)(this.width - this.thumbSize);
        int newValue = (int)((float)this.minValue + (float)(this.maxValue + 1 - this.minValue) * positionRatio);
        this.value.setFromOrdinal(Math.min(this.maxValue, Math.max(this.minValue, newValue)));
    }

    @Override
    protected void drawLabel(GuiGraphics guiGraphics) {
        int posY = this.y + 8 + this.titleSpacing;
        this.renderManager.drawText(guiGraphics, StringUtils.capitalize((String)((Enum)this.value.get()).name().toLowerCase()), this.x + this.width + this.titleSpacing, posY + this.thumbSize / 2 - 3, ModTheme.WHITE, false);
    }

    @Override
    public void bind(EnumProperty<TEnum> property) {
        this.value = property;
    }

    public TEnum getValue() {
        return (TEnum)((Enum)this.value.get());
    }
}

