/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.render.gui.component.components;

import com.wjbaker.ccm.render.ModTheme;
import com.wjbaker.ccm.render.gui.component.GuiComponent;
import com.wjbaker.ccm.render.gui.component.type.PanelOrientation;
import com.wjbaker.ccm.render.gui.screen.GuiScreen;
import com.wjbaker.ccm.render.type.GuiBounds;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;

public class PanelGuiComponent
extends GuiComponent {
    protected final int componentSpacing;
    protected final int padding;
    private final PanelOrientation orientation;
    protected boolean isBorderVisible;
    protected boolean isScissoringEnabled;

    public PanelGuiComponent(GuiScreen parentGuiScreen, int x, int y, int width, int height, PanelOrientation orientation) {
        super(parentGuiScreen, x, y, width, height);
        this.hoverBorderColour = this.baseBorderColour = ModTheme.DARK_GREY;
        this.currentBorderColour = this.baseBorderColour;
        this.hoverBackgroundColour = this.baseBackgroundColour = ModTheme.BLACK.setOpacity(200);
        this.currentBackgroundColour = this.baseBackgroundColour;
        this.components = new ArrayList();
        this.componentSpacing = 9;
        this.padding = 7;
        this.orientation = orientation;
        this.isBorderVisible = true;
        this.isScissoringEnabled = false;
    }

    public PanelGuiComponent(GuiScreen parentGuiScreen, int x, int y, int width, int height) {
        this(parentGuiScreen, x, y, width, height, PanelOrientation.VERTICAL);
    }

    @Override
    public void update() {
        super.update();
        this.components.forEach(GuiComponent::update);
    }

    @Override
    public void draw(GuiGraphics guiGraphics) {
        this.renderManager.drawBorderedRectangle(guiGraphics.m_280168_(), this.x, this.y, this.x + this.width, this.y + this.height, 2.0f, this.isBorderVisible ? this.currentBorderColour : ModTheme.TRANSPARENT, this.currentBackgroundColour);
        if (this.isScissoringEnabled) {
            this.renderManager.drawInsideBounds(new GuiBounds(this.x, this.y, this.width, this.height), () -> this.components.stream().filter(x -> !this.isComponentOutside((GuiComponent)x)).forEach(x -> x.draw(guiGraphics)));
        } else {
            this.components.stream().filter(x -> !this.isComponentOutside((GuiComponent)x)).forEach(x -> x.draw(guiGraphics));
        }
    }

    protected GuiBounds bounds() {
        return new GuiBounds(this.x, this.y, this.width, this.height);
    }

    private boolean isComponentOutside(GuiComponent component) {
        return component.getX() + component.getWidth() < this.bounds().x() || component.getX() > this.bounds().x() + this.bounds().width() || component.getY() + component.getHeight() < this.bounds().y() || component.getY() > this.bounds().y() + this.bounds().height();
    }

    public void addComponent(GuiComponent component) {
        this.components.add(component);
    }

    public void removeComponent(GuiComponent component) {
        this.components.remove(component);
    }

    public void pack() {
        if (this.orientation == PanelOrientation.VERTICAL) {
            this.packVertically();
        } else {
            this.packHorizontally();
        }
    }

    private void packVertically() {
        int height = this.padding;
        for (int index = 0; index < this.components.size(); ++index) {
            GuiComponent component = (GuiComponent)this.components.get(index);
            component.setPosition(this.x + this.padding, this.y + height);
            height += component.getHeight();
            if (index == this.components.size() - 1) continue;
            height += this.componentSpacing;
        }
        this.height = height + this.padding;
    }

    private void packHorizontally() {
        int width = 0;
        for (int index = 0; index < this.components.size(); ++index) {
            GuiComponent component = (GuiComponent)this.components.get(index);
            component.setPosition(this.x + width, this.y);
            width += component.getWidth();
            if (index == this.components.size() - 1) continue;
            width += this.componentSpacing;
        }
        this.width = width;
        int maxHeight = 0;
        for (GuiComponent component : this.components) {
            maxHeight = Math.max(maxHeight, component.getHeight());
        }
        this.height = maxHeight;
    }

    @Override
    public void setPosition(int x, int y) {
        super.setPosition(x, y);
        this.pack();
    }

    public void setScissoringEnabled(boolean isScissoringEnabled) {
        this.isScissoringEnabled = isScissoringEnabled;
    }
}

