/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair;

import com.google.common.collect.Lists;
import com.wjbaker.ccm.crosshair.properties.BooleanProperty;
import com.wjbaker.ccm.crosshair.properties.EnumProperty;
import com.wjbaker.ccm.crosshair.properties.IntegerProperty;
import com.wjbaker.ccm.crosshair.properties.RgbaProperty;
import com.wjbaker.ccm.crosshair.types.CrosshairStyle;
import com.wjbaker.ccm.crosshair.types.ICrosshairProperty;
import com.wjbaker.ccm.rendering.ModTheme;
import com.wjbaker.ccm.rendering.types.RGBA;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class CustomCrosshair {
    public final EnumProperty<CrosshairStyle.Styles> style;
    public final BooleanProperty isKeepDebugEnabled;
    public final RgbaProperty colour;
    public final BooleanProperty isAdaptiveColourEnabled;
    public final IntegerProperty width;
    public final IntegerProperty height;
    public final IntegerProperty gap;
    public final IntegerProperty thickness;
    public final IntegerProperty rotation;
    public final IntegerProperty scale;
    public final IntegerProperty offsetX;
    public final IntegerProperty offsetY;
    public final BooleanProperty isVisibleDefault;
    public final BooleanProperty isVisibleHiddenGui;
    public final BooleanProperty isVisibleDebug;
    public final BooleanProperty isVisibleThirdPerson;
    public final BooleanProperty isVisibleSpectator;
    public final BooleanProperty isVisibleHoldingRangedWeapon;
    public final BooleanProperty isVisibleHoldingThrowableItem;
    public final BooleanProperty isVisibleUsingSpyglass;
    public final BooleanProperty isOutlineEnabled;
    public final RgbaProperty outlineColour;
    public final BooleanProperty isDotEnabled;
    public final RgbaProperty dotColour;
    public final BooleanProperty isDynamicAttackIndicatorEnabled;
    public final BooleanProperty isDynamicBowEnabled;
    public final BooleanProperty isHighlightHostilesEnabled;
    public final BooleanProperty isHighlightPassivesEnabled;
    public final BooleanProperty isHighlightPlayersEnabled;
    public final RgbaProperty highlightHostilesColour;
    public final RgbaProperty highlightPassivesColour;
    public final RgbaProperty highlightPlayersColour;
    public final BooleanProperty isItemCooldownEnabled;
    public final RgbaProperty itemCooldownColour;
    public final BooleanProperty isRainbowEnabled;
    public final IntegerProperty rainbowSpeed;
    public final IntegerProperty rainbowTicks;
    public final BooleanProperty isToolDamageEnabled;
    public final BooleanProperty isProjectileIndicatorEnabled;
    public final List<ICrosshairProperty<?>> propertiesAsList;

    public CustomCrosshair() {
        Object[] objectArray = new ICrosshairProperty[38];
        this.style = new EnumProperty<Object>("crosshair_style", null);
        objectArray[0] = this.style;
        this.isKeepDebugEnabled = new BooleanProperty("crosshair_keep_debug_enabled", null);
        objectArray[1] = this.isKeepDebugEnabled;
        this.colour = new RgbaProperty("crosshair_colour", null);
        objectArray[2] = this.colour;
        this.isAdaptiveColourEnabled = new BooleanProperty("crosshair_adaptive_colour_enabled", null);
        objectArray[3] = this.isAdaptiveColourEnabled;
        this.width = new IntegerProperty("crosshair_width", null);
        objectArray[4] = this.width;
        this.height = new IntegerProperty("crosshair_height", null);
        objectArray[5] = this.height;
        this.gap = new IntegerProperty("crosshair_gap", null);
        objectArray[6] = this.gap;
        this.thickness = new IntegerProperty("crosshair_thickness", null);
        objectArray[7] = this.thickness;
        this.rotation = new IntegerProperty("crosshair_rotation", null);
        objectArray[8] = this.rotation;
        this.scale = new IntegerProperty("crosshair_scale", null);
        objectArray[9] = this.scale;
        this.offsetX = new IntegerProperty("crosshair_offset_x", null);
        objectArray[10] = this.offsetX;
        this.offsetY = new IntegerProperty("crosshair_offset_y", null);
        objectArray[11] = this.offsetY;
        this.isVisibleDefault = new BooleanProperty("visible_default", null);
        objectArray[12] = this.isVisibleDefault;
        this.isVisibleHiddenGui = new BooleanProperty("visible_hiddengui", null);
        objectArray[13] = this.isVisibleHiddenGui;
        this.isVisibleDebug = new BooleanProperty("visible_debug", null);
        objectArray[14] = this.isVisibleDebug;
        this.isVisibleThirdPerson = new BooleanProperty("visible_thirdperson", null);
        objectArray[15] = this.isVisibleThirdPerson;
        this.isVisibleSpectator = new BooleanProperty("visible_spectator", null);
        objectArray[16] = this.isVisibleSpectator;
        this.isVisibleHoldingRangedWeapon = new BooleanProperty("visible_holding_ranged_weapon", null);
        objectArray[17] = this.isVisibleHoldingRangedWeapon;
        this.isVisibleHoldingThrowableItem = new BooleanProperty("visible_holding_throwable_item", null);
        objectArray[18] = this.isVisibleHoldingThrowableItem;
        this.isVisibleUsingSpyglass = new BooleanProperty("visible_holding_spyglass", null);
        objectArray[19] = this.isVisibleUsingSpyglass;
        this.isOutlineEnabled = new BooleanProperty("outline_enabled", null);
        objectArray[20] = this.isOutlineEnabled;
        this.outlineColour = new RgbaProperty("outline_colour", null);
        objectArray[21] = this.outlineColour;
        this.isDotEnabled = new BooleanProperty("dot_enabled", null);
        objectArray[22] = this.isDotEnabled;
        this.dotColour = new RgbaProperty("dot_colour", null);
        objectArray[23] = this.dotColour;
        this.isDynamicAttackIndicatorEnabled = new BooleanProperty("dynamic_attackindicator_enabled", null);
        objectArray[24] = this.isDynamicAttackIndicatorEnabled;
        this.isDynamicBowEnabled = new BooleanProperty("dynamic_bow_enabled", null);
        objectArray[25] = this.isDynamicBowEnabled;
        this.isHighlightHostilesEnabled = new BooleanProperty("highlight_hostile_enabled", null);
        objectArray[26] = this.isHighlightHostilesEnabled;
        this.isHighlightPassivesEnabled = new BooleanProperty("highlight_passive_enabled", null);
        objectArray[27] = this.isHighlightPassivesEnabled;
        this.isHighlightPlayersEnabled = new BooleanProperty("highlight_players_enabled", null);
        objectArray[28] = this.isHighlightPlayersEnabled;
        this.highlightHostilesColour = new RgbaProperty("highlight_hostile_colour", null);
        objectArray[29] = this.highlightHostilesColour;
        this.highlightPassivesColour = new RgbaProperty("highlight_passive_colour", null);
        objectArray[30] = this.highlightPassivesColour;
        this.highlightPlayersColour = new RgbaProperty("highlight_players_colour", null);
        objectArray[31] = this.highlightPlayersColour;
        this.isItemCooldownEnabled = new BooleanProperty("itemcooldown_enabled", null);
        objectArray[32] = this.isItemCooldownEnabled;
        this.itemCooldownColour = new RgbaProperty("itemcooldown_colour", null);
        objectArray[33] = this.itemCooldownColour;
        this.isRainbowEnabled = new BooleanProperty("rainbow_enabled", null);
        objectArray[34] = this.isRainbowEnabled;
        this.rainbowSpeed = new IntegerProperty("rainbow_speed", null);
        objectArray[35] = this.rainbowSpeed;
        this.isToolDamageEnabled = new BooleanProperty("tool_damage_enabled", null);
        objectArray[36] = this.isToolDamageEnabled;
        this.isProjectileIndicatorEnabled = new BooleanProperty("projectile_indicator_enabled", null);
        objectArray[37] = this.isProjectileIndicatorEnabled;
        this.propertiesAsList = Lists.newArrayList((Object[])objectArray);
        this.resetProperties();
        this.rainbowTicks = new IntegerProperty("rainbow_ticks", 0);
    }

    public void resetProperties() {
        this.style.set(CrosshairStyle.Styles.CROSS);
        this.isKeepDebugEnabled.set(false);
        this.colour.set(ModTheme.WHITE);
        this.isAdaptiveColourEnabled.set(false);
        this.width.set(4);
        this.height.set(4);
        this.gap.set(3);
        this.thickness.set(1);
        this.rotation.set(0);
        this.scale.set(100);
        this.offsetX.set(0);
        this.offsetY.set(0);
        this.isVisibleDefault.set(true);
        this.isVisibleHiddenGui.set(true);
        this.isVisibleDebug.set(true);
        this.isVisibleThirdPerson.set(false);
        this.isVisibleSpectator.set(true);
        this.isVisibleHoldingRangedWeapon.set(true);
        this.isVisibleHoldingThrowableItem.set(true);
        this.isVisibleUsingSpyglass.set(false);
        this.isOutlineEnabled.set(true);
        this.outlineColour.set(ModTheme.BLACK);
        this.isDotEnabled.set(false);
        this.dotColour.set(ModTheme.WHITE);
        this.isDynamicAttackIndicatorEnabled.set(true);
        this.isDynamicBowEnabled.set(true);
        this.isHighlightHostilesEnabled.set(true);
        this.isHighlightPassivesEnabled.set(true);
        this.isHighlightPlayersEnabled.set(true);
        this.highlightHostilesColour.set(new RGBA(220, 40, 40, 255));
        this.highlightPassivesColour.set(new RGBA(40, 230, 40, 255));
        this.highlightPlayersColour.set(new RGBA(60, 60, 240, 255));
        this.isItemCooldownEnabled.set(true);
        this.itemCooldownColour.set(ModTheme.WHITE.setOpacity(80));
        this.isRainbowEnabled.set(false);
        this.rainbowSpeed.set(500);
        this.isToolDamageEnabled.set(true);
        this.isProjectileIndicatorEnabled.set(true);
    }
}

