/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.computed.properties;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.rendering.types.RGBA;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_5354;

@Environment(value=EnvType.CLIENT)
public abstract class ComputeColour {
    private static final class_310 mc = class_310.method_1551();

    private ComputeColour() {
    }

    public static RGBA compute(CustomCrosshair crosshair) {
        class_1297 target = ComputeColour.mc.field_1692;
        Boolean isHighlightPlayersEnabled = (Boolean)crosshair.isHighlightPlayersEnabled.get();
        if (isHighlightPlayersEnabled.booleanValue() && target instanceof class_1657) {
            return (RGBA)crosshair.highlightPlayersColour.get();
        }
        Boolean isHighlightHostilesEnabled = (Boolean)crosshair.isHighlightHostilesEnabled.get();
        if (isHighlightHostilesEnabled.booleanValue() && (target instanceof class_1569 || target instanceof class_5354)) {
            return (RGBA)crosshair.highlightHostilesColour.get();
        }
        Boolean isHighlightPassivesEnabled = (Boolean)crosshair.isHighlightPassivesEnabled.get();
        if (isHighlightPassivesEnabled.booleanValue() && target instanceof class_1296) {
            return (RGBA)crosshair.highlightPassivesColour.get();
        }
        if (((Boolean)crosshair.isRainbowEnabled.get()).booleanValue()) {
            return ComputeColour.getRainbowColour(crosshair);
        }
        return (RGBA)crosshair.colour.get();
    }

    private static RGBA getRainbowColour(CustomCrosshair crosshair) {
        int ticks = (Integer)crosshair.rainbowTicks.get() + 1;
        if (ticks > 125000) {
            ticks = 0;
        }
        crosshair.rainbowTicks.set(ticks);
        int opacity = ((RGBA)crosshair.colour.get()).getOpacity();
        Integer speed = (Integer)crosshair.rainbowSpeed.get();
        return new RGBA(255, 255, 255, opacity).setRed(ComputeColour.getRainbowColourComponent(ticks, 0.0f, speed)).setGreen(ComputeColour.getRainbowColourComponent(ticks, 2.0f, speed)).setBlue(ComputeColour.getRainbowColourComponent(ticks, 4.0f, speed));
    }

    private static int getRainbowColourComponent(int ticks, float offset, int speed) {
        return (int)(Math.sin((float)(ticks * speed) / 20000.0f + offset) * 127.0 + 128.0);
    }
}

