/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.properties;

import com.wjbaker.ccm.crosshair.types.ICrosshairProperty;
import java.util.EnumSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class EnumProperty<TEnum extends Enum<TEnum>>
extends ICrosshairProperty<TEnum> {
    public EnumProperty(String alias, TEnum value) {
        super(alias, value);
    }

    @Override
    public String forConfig() {
        return String.valueOf(((Enum)this.get()).ordinal());
    }

    @Override
    public void setFromConfig(String value) {
        int ordinal = Integer.parseInt(value);
        this.set(this.enumOf(ordinal));
    }

    public void setFromOrdinal(int value) {
        this.set(this.enumOf(value));
    }

    private TEnum enumOf(int ordinal) {
        Class<?> enumClass = ((Enum)this.get()).getClass();
        return (TEnum)((Enum)EnumSet.allOf(enumClass).stream().filter(x -> x.ordinal() == ordinal).findFirst().orElse(null));
    }
}

