/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.rendering;

import com.google.common.collect.ImmutableSet;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.computed.ComputedProperties;
import com.wjbaker.ccm.crosshair.computed.properties.ComputeIndicators;
import com.wjbaker.ccm.crosshair.styles.ArrowStyle;
import com.wjbaker.ccm.crosshair.styles.CircleStyle;
import com.wjbaker.ccm.crosshair.styles.CrossStyle;
import com.wjbaker.ccm.crosshair.styles.DebugStyle;
import com.wjbaker.ccm.crosshair.styles.DrawnStyle;
import com.wjbaker.ccm.crosshair.styles.SquareStyle;
import com.wjbaker.ccm.crosshair.styles.TriangleStyle;
import com.wjbaker.ccm.crosshair.styles.VanillaStyle;
import com.wjbaker.ccm.crosshair.types.CrosshairStyle;
import com.wjbaker.ccm.rendering.ModTheme;
import com.wjbaker.ccm.rendering.RenderManager;
import com.wjbaker.ccm.rendering.types.RGBA;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_10799;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4061;
import net.minecraft.class_746;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public final class CrosshairRenderManager {
    private static final class_2960 CROSSHAIR_ATTACK_INDICATOR_FULL_TEXTURE = class_2960.method_60656((String)"hud/crosshair_attack_indicator_full");
    private static final class_2960 CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_TEXTURE = class_2960.method_60656((String)"hud/crosshair_attack_indicator_background");
    private static final class_2960 CROSSHAIR_ATTACK_INDICATOR_PROGRESS_TEXTURE = class_2960.method_60656((String)"hud/crosshair_attack_indicator_progress");
    private final RenderManager renderManager;
    private final Set<class_1792> itemCooldownItems = ImmutableSet.of((Object)class_1802.field_8634, (Object)class_1802.field_8233);

    public CrosshairRenderManager() {
        this.renderManager = new RenderManager();
    }

    public void draw(CustomCrosshair crosshair, class_332 drawContext, int x, int y) {
        ComputedProperties computedProperties = new ComputedProperties(crosshair);
        if (!computedProperties.isVisible()) {
            return;
        }
        CrosshairStyle.Styles calculatedStyle = class_310.method_1551().field_1705.method_53531().method_53536() && (Boolean)crosshair.isKeepDebugEnabled.get() != false ? CrosshairStyle.Styles.DEBUG : (CrosshairStyle.Styles)((Object)crosshair.style.get());
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        CrosshairStyle style = this.mapCrosshairStyle(matrixStack, calculatedStyle, crosshair);
        Boolean isItemCooldownEnabled = (Boolean)crosshair.isItemCooldownEnabled.get();
        Boolean isDotEnabled = (Boolean)crosshair.isDotEnabled.get();
        if (isItemCooldownEnabled.booleanValue()) {
            this.drawItemCooldownIndicator(drawContext, crosshair, computedProperties, x, y);
        }
        if (isDotEnabled.booleanValue() && crosshair.style.get() != CrosshairStyle.Styles.VANILLA) {
            this.renderManager.drawCircle(drawContext, x, y, 0.5f, 1.0f, (RGBA)crosshair.dotColour.get());
        }
        this.drawDefaultAttackIndicator(drawContext);
        int renderX = x + (Integer)crosshair.offsetX.get();
        int renderY = y + (Integer)crosshair.offsetY.get();
        this.drawIndicators(drawContext, crosshair, computedProperties, renderX, renderY);
        this.preTransformation(drawContext, crosshair, renderX, renderY);
        style.draw(drawContext, 0, 0, computedProperties);
        this.postTransformation(drawContext, renderX, renderY);
    }

    private CrosshairStyle mapCrosshairStyle(Matrix3x2fStack matrixStack, CrosshairStyle.Styles style, CustomCrosshair crosshair) {
        return switch (style) {
            case CrosshairStyle.Styles.VANILLA -> new VanillaStyle(matrixStack, crosshair);
            case CrosshairStyle.Styles.CIRCLE -> new CircleStyle(matrixStack, crosshair);
            case CrosshairStyle.Styles.SQUARE -> new SquareStyle(matrixStack, crosshair);
            case CrosshairStyle.Styles.TRIANGLE -> new TriangleStyle(matrixStack, crosshair);
            case CrosshairStyle.Styles.ARROW -> new ArrowStyle(matrixStack, crosshair);
            case CrosshairStyle.Styles.DEBUG -> new DebugStyle(matrixStack, crosshair);
            case CrosshairStyle.Styles.DRAWN -> new DrawnStyle(matrixStack, crosshair);
            default -> new CrossStyle(matrixStack, crosshair);
        };
    }

    private void preTransformation(class_332 drawContext, CustomCrosshair crosshair, int x, int y) {
        Matrix3x2fStack matrices = drawContext.method_51448();
        matrices.pushMatrix();
        Integer rotation = (Integer)crosshair.rotation.get();
        Integer scale = (Integer)crosshair.scale.get();
        matrices.scale((float)scale.intValue() / 100.0f, (float)scale.intValue() / 100.0f);
        matrices.rotate((float)rotation.intValue());
        matrices.translateLocal((float)x, (float)y);
    }

    private void postTransformation(class_332 drawContext, int x, int y) {
        Matrix3x2fStack matrices = drawContext.method_51448();
        matrices.popMatrix();
    }

    private void drawItemCooldownIndicator(class_332 drawContext, CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        RGBA colour = (RGBA)crosshair.itemCooldownColour.get();
        Integer width = (Integer)crosshair.width.get();
        Integer height = (Integer)crosshair.height.get();
        int maxSize = Math.max(width, height);
        int offset = 3;
        for (class_1792 item : this.itemCooldownItems) {
            float cooldown = player.method_7357().method_7905(item.method_7854(), 0.0f);
            if (cooldown == 0.0f) continue;
            int progress = Math.round(360.0f - 360.0f * cooldown);
            this.renderManager.drawPartialCircle(drawContext, x, y, computedProperties.gap() + maxSize + offset, 0, progress, 2.0f, colour);
            offset += 3;
        }
    }

    private void drawDefaultAttackIndicator(class_332 drawContext) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.method_42565().method_41753() == class_4061.field_18152 && mc.field_1724 != null) {
            float f = mc.field_1724.method_7261(0.0f);
            boolean bl = false;
            if (mc.field_1692 instanceof class_1309 && f >= 1.0f) {
                bl = mc.field_1724.method_7279() > 5.0f;
                bl &= mc.field_1692.method_5805();
            }
            int j = mc.method_22683().method_4502() / 2 - 7 + 16;
            int k = mc.method_22683().method_4486() / 2 - 8;
            if (bl) {
                drawContext.method_52706(class_10799.field_56890, CROSSHAIR_ATTACK_INDICATOR_FULL_TEXTURE, k, j, 16, 16);
            } else if (f < 1.0f) {
                int l = (int)(f * 17.0f);
                drawContext.method_52706(class_10799.field_56890, CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_TEXTURE, k, j, 16, 4);
                drawContext.method_70846(class_10799.field_56890, CROSSHAIR_ATTACK_INDICATOR_PROGRESS_TEXTURE, 16, 4, 0, 0, k, j, l, 4);
            }
        }
    }

    private void drawIndicators(class_332 drawContext, CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        int drawX = x + (Integer)crosshair.gap.get() + 5;
        int drawY = y + (Integer)crosshair.gap.get() + 5;
        class_310 mc = class_310.method_1551();
        mc.method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        List<ComputeIndicators.IndicatorItem> indicatorItems = computedProperties.indicatorItems();
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        for (ComputeIndicators.IndicatorItem indicatorItem : indicatorItems) {
            matrixStack.scale(0.5f, 0.5f);
            drawContext.method_51427(indicatorItem.icon(), drawX * 2 - 8, drawY * 2 - 8);
            matrixStack.scale(2.0f, 2.0f);
            this.renderManager.drawSmallText(drawContext, indicatorItem.text(), drawX + 5, drawY, ModTheme.WHITE, true);
            drawX += 15;
        }
    }
}

