/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm;

import com.wjbaker.ccm.config.ConfigManager;
import com.wjbaker.ccm.config.GlobalProperties;
import com.wjbaker.ccm.events.KeyBindings;
import com.wjbaker.ccm.gui.screen.screens.editCrosshair.EditCrosshairGuiScreen;
import com.wjbaker.ccm.helpers.Helper;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.concurrent.Executors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="custom_crosshair_mod")
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public final class CustomCrosshairMod {
    public static CustomCrosshairMod INSTANCE;
    public static final String TITLE = "Custom Crosshair Mod";
    public static final String VERSION = "1.6.1-forge";
    public static final String MC_VERSION = "1.21.10-forge";
    public static final String CURSEFORGE_PAGE = "https://www.curseforge.com/projects/242995/";
    public static final String MC_FORUMS_PAGE = "https://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2637819/";
    public static final String PATREON_PAGE = "https://www.patreon.com/bePatron?u=66431720";
    public static final String PAYPAL_PAGE = "https://www.paypal.com/cgi-bin/webscr?return=https://www.curseforge.com/projects/242995&cn=Add+special+instructions+to+the+addon+author()&business=sparkless101%40gmail.com&bn=PP-DonationsBF:btn_donateCC_LG.gif:NonHosted&cancel_return=https://www.curseforge.com/projects/242995&lc=US&item_name=Custom+Crosshair+Mod+(from+curseforge.com)&cmd=_donations&rm=1&no_shipping=1&currency_code=USD";
    private final Logger logger = LogManager.getLogger(CustomCrosshairMod.class);
    private final GlobalProperties properties = new GlobalProperties();
    private ConfigManager configManager;

    public CustomCrosshairMod(FMLJavaModLoadingContext context) {
        INSTANCE = this;
        this.loadConfig();
        this.checkVersionAsync();
        this.properties.getCustomCrosshairDrawer().loadImage();
        RegisterKeyMappingsEvent.getBus((BusGroup)context.getModBusGroup()).addListener(event -> event.register((KeyMapping)KeyBindings.EDIT_CROSSHAIR.get()));
    }

    private void loadConfig() {
        this.configManager = new ConfigManager("crosshair_config.ccmcfg", this.properties.getCrosshair(), this.properties.getIsModEnabled());
        if (!this.configManager.read() && !this.configManager.write()) {
            this.error("Config Manager (Load)", "Unable to load or write config.", new Object[0]);
        }
    }

    private void checkVersionAsync() {
        Executors.newSingleThreadExecutor().submit(this::checkVersion);
    }

    private void checkVersion() {
        try (BufferedReader reader = Helper.getUrl("https://pastebin.com/raw/B2sL8QCh");){
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                String[] lineSplit = currentLine.split(" ");
                if (lineSplit.length != 2) continue;
                String mcVersion = lineSplit[0];
                String expectedModVersion = lineSplit[1];
                if (!mcVersion.equals(MC_VERSION) || expectedModVersion.equals(VERSION)) continue;
                this.log("Version Checker", "Not using latest version of Customer Crosshair Mod.", new Object[0]);
                this.properties.setLatestVersion(false);
            }
        }
        catch (IOException e) {
            this.error("Version Checker", "Unable to check the version.", new Object[0]);
        }
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent.Post event) {
        if (Minecraft.getInstance().screen == null && ((KeyMapping)KeyBindings.EDIT_CROSSHAIR.get()).isDown()) {
            Minecraft.getInstance().setScreen((Screen)new EditCrosshairGuiScreen(CustomCrosshairMod.INSTANCE.properties.getCrosshair()));
        }
    }

    public GlobalProperties properties() {
        return this.properties;
    }

    public ConfigManager configManager() {
        return this.configManager;
    }

    public void log(String action, String message, Object ... values) {
        this.logger.info(String.format("[%s] %s", action, message), values);
    }

    public void error(String action, String message, Object ... values) {
        this.logger.error(String.format("[%s] %s", action, message), values);
    }
}

