/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.computed.properties;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.rendering.types.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;

public abstract class ComputeColour {
    private static final Minecraft mc = Minecraft.getInstance();

    private ComputeColour() {
    }

    public static RGBA compute(CustomCrosshair crosshair) {
        LivingEntity livingTarget;
        Entity target = ComputeColour.mc.crosshairPickEntity;
        if (ComputeColour.mc.player != null && target instanceof LivingEntity && !ComputeColour.mc.player.canAttack(livingTarget = (LivingEntity)target)) {
            return (RGBA)crosshair.colour.get();
        }
        Boolean isHighlightPlayersEnabled = (Boolean)crosshair.isHighlightPlayersEnabled.get();
        if (isHighlightPlayersEnabled.booleanValue() && target instanceof Player) {
            return (RGBA)crosshair.highlightPlayersColour.get();
        }
        Boolean isHighlightHostilesEnabled = (Boolean)crosshair.isHighlightHostilesEnabled.get();
        if (isHighlightHostilesEnabled.booleanValue() && target instanceof Enemy) {
            return (RGBA)crosshair.highlightHostilesColour.get();
        }
        Boolean isHighlightPassivesEnabled = (Boolean)crosshair.isHighlightPassivesEnabled.get();
        if (isHighlightPassivesEnabled.booleanValue() && target instanceof LivingEntity) {
            return (RGBA)crosshair.highlightPassivesColour.get();
        }
        if (((Boolean)crosshair.isRainbowEnabled.get()).booleanValue()) {
            return ComputeColour.getRainbowColour(crosshair);
        }
        return (RGBA)crosshair.colour.get();
    }

    private static RGBA getRainbowColour(CustomCrosshair crosshair) {
        int ticks = (Integer)crosshair.rainbowTicks.get() + 1;
        if (ticks > 125000) {
            ticks = 0;
        }
        crosshair.rainbowTicks.set(ticks);
        int opacity = ((RGBA)crosshair.colour.get()).getOpacity();
        Integer speed = (Integer)crosshair.rainbowSpeed.get();
        return new RGBA(255, 255, 255, opacity).setRed(ComputeColour.getRainbowColourComponent(ticks, 0.0f, speed)).setGreen(ComputeColour.getRainbowColourComponent(ticks, 2.0f, speed)).setBlue(ComputeColour.getRainbowColourComponent(ticks, 4.0f, speed));
    }

    private static int getRainbowColourComponent(int ticks, float offset, int speed) {
        return (int)(Math.sin((float)(ticks * speed) / 20000.0f + offset) * 127.0 + 128.0);
    }
}

