/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.computed.properties;

import com.google.common.collect.ImmutableMap;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public abstract class ComputeGap {
    private static final Minecraft mc = Minecraft.getInstance();
    private static final Map<Item, Float> ITEM_DURATIONS = ImmutableMap.of((Object)Items.BOW, (Object)Float.valueOf(20.0f), (Object)Items.TRIDENT, (Object)Float.valueOf(10.0f), (Object)Items.CROSSBOW, (Object)Float.valueOf(0.0f));

    private ComputeGap() {
    }

    public static int compute(CustomCrosshair crosshair) {
        Integer baseGap = (Integer)crosshair.gap.get();
        if (ComputeGap.mc.player == null) {
            return baseGap;
        }
        boolean isSpectator = ComputeGap.mc.player.isSpectator();
        ItemStack mainHandItem = ComputeGap.mc.player.getMainHandItem();
        boolean isHoldingItem = !mainHandItem.isEmpty() || !ComputeGap.mc.player.getOffhandItem().isEmpty();
        Boolean isDynamicBowEnabled = (Boolean)crosshair.isDynamicBowEnabled.get();
        Boolean isDynamicAttackIndicatorEnabled = (Boolean)crosshair.isDynamicAttackIndicatorEnabled.get();
        if (isSpectator || !isHoldingItem || !isDynamicAttackIndicatorEnabled.booleanValue() && !isDynamicBowEnabled.booleanValue()) {
            return baseGap;
        }
        int gapModifier = 2;
        Float usageItemDuration = ITEM_DURATIONS.get(ComputeGap.mc.player.getUseItem().getItem());
        if (isDynamicBowEnabled.booleanValue() && usageItemDuration != null) {
            float progress;
            if (ComputeGap.mc.player.getUseItem().getItem() == Items.CROSSBOW) {
                usageItemDuration = Float.valueOf(CrossbowItem.getChargeDuration((ItemStack)ComputeGap.mc.player.getUseItem(), (LivingEntity)ComputeGap.mc.player));
                progress = Math.min(usageItemDuration.floatValue(), (float)ComputeGap.mc.player.getTicksUsingItem());
            } else {
                progress = Math.min(usageItemDuration.floatValue(), (float)ComputeGap.mc.player.getTicksUsingItem());
            }
            return baseGap + Math.round((usageItemDuration.floatValue() - progress) * (float)gapModifier);
        }
        if (isDynamicAttackIndicatorEnabled.booleanValue()) {
            float currentAttackUsage = ComputeGap.mc.player.getAttackStrengthScale(0.0f);
            float maxAttackUsage = 1.0f;
            if (ComputeGap.mc.player.getCurrentItemAttackStrengthDelay() > 5.0f && currentAttackUsage < maxAttackUsage) {
                return baseGap + Math.round((maxAttackUsage - currentAttackUsage) * (float)gapModifier * 20.0f);
            }
        }
        return baseGap;
    }
}

