/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.computed.properties;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;

public abstract class ComputeIndicators {
    private static final Minecraft mc = Minecraft.getInstance();

    private ComputeIndicators() {
    }

    public static List<IndicatorItem> getIndicatorItems(CustomCrosshair crosshair) {
        ArrayList<IndicatorItem> indicators = new ArrayList<IndicatorItem>();
        ComputeIndicators.mutateForToolDamage(indicators, crosshair);
        ComputeIndicators.mutateForProjectiles(indicators, crosshair);
        return indicators;
    }

    private static void mutateForToolDamage(List<IndicatorItem> indicators, CustomCrosshair crosshair) {
        if (!((Boolean)crosshair.isToolDamageEnabled.get()).booleanValue()) {
            return;
        }
        if (ComputeIndicators.mc.player == null) {
            return;
        }
        ItemStack tool = ComputeIndicators.mc.player.getMainHandItem();
        if (!tool.isDamageableItem()) {
            return;
        }
        int remainingDamage = tool.getMaxDamage() - tool.getDamageValue();
        if (remainingDamage > 10) {
            return;
        }
        indicators.add(new IndicatorItem("" + remainingDamage, tool));
    }

    private static void mutateForProjectiles(List<IndicatorItem> indicators, CustomCrosshair crosshair) {
        if (!((Boolean)crosshair.isProjectileIndicatorEnabled.get()).booleanValue() || ComputeIndicators.mc.player == null) {
            return;
        }
        ItemStack tool = ComputeIndicators.mc.player.getMainHandItem();
        ItemStack projectile = ComputeIndicators.mc.player.getProjectile(tool);
        if (projectile == ItemStack.EMPTY) {
            return;
        }
        String count = ComputeIndicators.mc.player.isCreative() ? "" : Integer.valueOf(projectile.getCount());
        indicators.add(new IndicatorItem(String.valueOf(count), projectile));
    }

    public record IndicatorItem(String text, ItemStack icon) {
    }
}

