/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.computed.properties;

import com.google.common.collect.ImmutableSet;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public abstract class ComputeVisibility {
    private static final Minecraft mc = Minecraft.getInstance();
    private static final Set<Item> RANGED_WEAPONS = ImmutableSet.of((Object)Items.BOW, (Object)Items.TRIDENT, (Object)Items.CROSSBOW);
    private static final Set<Item> THROWABLE_ITEMS = ImmutableSet.of((Object)Items.ENDER_PEARL, (Object)Items.ENDER_EYE);

    private ComputeVisibility() {
    }

    public static boolean compute(CustomCrosshair crosshair) {
        boolean isThirdPerson;
        if (ComputeVisibility.mc.player == null) {
            return false;
        }
        if (!((Boolean)crosshair.isVisibleDefault.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)crosshair.isVisibleHiddenGui.get()).booleanValue() && ComputeVisibility.mc.options.hideGui) {
            return false;
        }
        boolean bl = isThirdPerson = !ComputeVisibility.mc.options.getCameraType().isFirstPerson();
        if (!((Boolean)crosshair.isVisibleThirdPerson.get()).booleanValue() && isThirdPerson) {
            return false;
        }
        if (!((Boolean)crosshair.isVisibleDebug.get()).booleanValue() && mc.getDebugOverlay().showDebugScreen()) {
            return false;
        }
        if (!((Boolean)crosshair.isVisibleSpectator.get()).booleanValue() && ComputeVisibility.mc.player.isSpectator()) {
            return false;
        }
        if (!((Boolean)crosshair.isVisibleHoldingRangedWeapon.get()).booleanValue() && ComputeVisibility.isHoldingItem((Player)ComputeVisibility.mc.player, RANGED_WEAPONS)) {
            return false;
        }
        if (!((Boolean)crosshair.isVisibleHoldingThrowableItem.get()).booleanValue() && ComputeVisibility.isHoldingItem((Player)ComputeVisibility.mc.player, THROWABLE_ITEMS)) {
            return false;
        }
        return (Boolean)crosshair.isVisibleUsingSpyglass.get() != false || !ComputeVisibility.mc.player.isScoping();
    }

    private static boolean isHoldingItem(Player player, Set<Item> items) {
        ItemStack mainHandItem = player.getMainHandItem();
        boolean isMainHand = items.contains(mainHandItem.getItem());
        boolean isOffhand = items.contains(player.getOffhandItem().getItem());
        return isMainHand || isOffhand && mainHandItem.isEmpty();
    }
}

