/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.rendering;

import com.google.common.collect.ImmutableSet;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.computed.ComputedProperties;
import com.wjbaker.ccm.crosshair.computed.properties.ComputeIndicators;
import com.wjbaker.ccm.crosshair.styles.ArrowStyle;
import com.wjbaker.ccm.crosshair.styles.CircleStyle;
import com.wjbaker.ccm.crosshair.styles.CrossStyle;
import com.wjbaker.ccm.crosshair.styles.DebugStyle;
import com.wjbaker.ccm.crosshair.styles.DrawnStyle;
import com.wjbaker.ccm.crosshair.styles.SquareStyle;
import com.wjbaker.ccm.crosshair.styles.TriangleStyle;
import com.wjbaker.ccm.crosshair.styles.VanillaStyle;
import com.wjbaker.ccm.crosshair.types.BaseCrosshairStyle;
import com.wjbaker.ccm.rendering.ModTheme;
import com.wjbaker.ccm.rendering.RenderManager;
import com.wjbaker.ccm.rendering.types.RGBA;
import java.util.List;
import java.util.Set;
import net.minecraft.client.AttackIndicatorStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.joml.Matrix3x2fStack;

public final class CrosshairRenderManager {
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_attack_indicator_full");
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_attack_indicator_background");
    private static final ResourceLocation CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE = ResourceLocation.withDefaultNamespace((String)"hud/crosshair_attack_indicator_progress");
    private final RenderManager renderManager;
    private final Set<Item> itemCooldownItems = ImmutableSet.of((Object)Items.ENDER_PEARL, (Object)Items.CHORUS_FRUIT);

    public CrosshairRenderManager() {
        this.renderManager = new RenderManager();
    }

    public void draw(CustomCrosshair crosshair, GuiGraphics guiGraphics, int x, int y) {
        ComputedProperties computedProperties = new ComputedProperties(crosshair);
        if (!computedProperties.isVisible()) {
            return;
        }
        BaseCrosshairStyle.Styles calculatedStyle = Minecraft.getInstance().getDebugOverlay().showDebugScreen() && (Boolean)crosshair.isKeepDebugEnabled.get() != false ? BaseCrosshairStyle.Styles.DEBUG : (BaseCrosshairStyle.Styles)((Object)crosshair.style.get());
        BaseCrosshairStyle style = this.mapCrosshairStyle(calculatedStyle, crosshair);
        Boolean isItemCooldownEnabled = (Boolean)crosshair.isItemCooldownEnabled.get();
        Boolean isDotEnabled = (Boolean)crosshair.isDotEnabled.get();
        Matrix3x2fStack matrices = guiGraphics.pose();
        int renderX = x + (Integer)crosshair.offsetX.get();
        int renderY = y + (Integer)crosshair.offsetY.get();
        this.drawIndicators(guiGraphics, crosshair, computedProperties, renderX, renderY);
        this.preTransformation(matrices, crosshair, renderX, renderY);
        this.drawDefaultAttackIndicator(guiGraphics);
        if (isDotEnabled.booleanValue() && crosshair.style.get() != BaseCrosshairStyle.Styles.VANILLA) {
            this.renderManager.drawCircle(guiGraphics, 0.0f, 0.0f, 0.5f, 1.0f, (RGBA)crosshair.dotColour.get());
        }
        if (isItemCooldownEnabled.booleanValue()) {
            this.drawItemCooldownIndicator(guiGraphics, crosshair, computedProperties);
        }
        style.draw(guiGraphics, 0, 0, computedProperties);
        this.postTransformation(matrices, crosshair);
    }

    private BaseCrosshairStyle mapCrosshairStyle(BaseCrosshairStyle.Styles style, CustomCrosshair crosshair) {
        return switch (style) {
            case BaseCrosshairStyle.Styles.VANILLA -> new VanillaStyle(crosshair);
            case BaseCrosshairStyle.Styles.CIRCLE -> new CircleStyle(crosshair);
            case BaseCrosshairStyle.Styles.SQUARE -> new SquareStyle(crosshair);
            case BaseCrosshairStyle.Styles.TRIANGLE -> new TriangleStyle(crosshair);
            case BaseCrosshairStyle.Styles.ARROW -> new ArrowStyle(crosshair);
            case BaseCrosshairStyle.Styles.DEBUG -> new DebugStyle(crosshair);
            case BaseCrosshairStyle.Styles.DRAWN -> new DrawnStyle(crosshair);
            default -> new CrossStyle(crosshair);
        };
    }

    private void preTransformation(Matrix3x2fStack matrices, CustomCrosshair crosshair, int x, int y) {
        if (crosshair.style.get() == BaseCrosshairStyle.Styles.DEBUG) {
            return;
        }
        matrices.pushMatrix();
        Integer rotation = (Integer)crosshair.rotation.get();
        int scale = (Integer)crosshair.scale.get() - 2;
        matrices.scale((float)scale / 100.0f, (float)scale / 100.0f);
        matrices.rotateLocal((float)rotation.intValue() * 0.01745329f);
        matrices.translateLocal((float)x, (float)y);
    }

    private void postTransformation(Matrix3x2fStack matrixStack, CustomCrosshair crosshair) {
        if (crosshair.style.get() == BaseCrosshairStyle.Styles.DEBUG) {
            return;
        }
        matrixStack.popMatrix();
    }

    private void drawItemCooldownIndicator(GuiGraphics guiGraphics, CustomCrosshair crosshair, ComputedProperties computedProperties) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        RGBA colour = (RGBA)crosshair.itemCooldownColour.get();
        Integer width = (Integer)crosshair.width.get();
        Integer height = (Integer)crosshair.height.get();
        int maxSize = Math.max(width, height);
        int offset = 3;
        for (Item item : this.itemCooldownItems) {
            float cooldown = player.getCooldowns().getCooldownPercent(item.getDefaultInstance(), 0.0f);
            if (cooldown == 0.0f) continue;
            int progress = Math.round(360.0f - 360.0f * cooldown);
            this.renderManager.drawPartialCircle(guiGraphics, 0.0f, 0.0f, computedProperties.gap() + maxSize + offset, 0, progress, 2.0f, colour);
            offset += 3;
        }
    }

    private void drawDefaultAttackIndicator(GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.options.attackIndicator().get() == AttackIndicatorStatus.CROSSHAIR && mc.player != null) {
            float f = mc.player.getAttackStrengthScale(0.0f);
            boolean flag = false;
            if (mc.crosshairPickEntity instanceof LivingEntity && f < 1.0f) {
                flag = mc.player.getCurrentItemAttackStrengthDelay() > 5.0f;
                flag &= mc.crosshairPickEntity.isAlive();
            }
            int drawX = -8;
            int drawY = 9;
            if (flag) {
                guiGraphics.blitSprite(RenderPipelines.CROSSHAIR, CROSSHAIR_ATTACK_INDICATOR_FULL_SPRITE, drawX, drawY, 16, 16);
            } else if (f < 1.0f) {
                int l = (int)(f * 17.0f);
                guiGraphics.blitSprite(RenderPipelines.CROSSHAIR, CROSSHAIR_ATTACK_INDICATOR_BACKGROUND_SPRITE, drawX, drawY, 16, 4);
                guiGraphics.blitSprite(RenderPipelines.CROSSHAIR, CROSSHAIR_ATTACK_INDICATOR_PROGRESS_SPRITE, 16, 4, 0, 0, drawX, drawY, l, 4);
            }
        }
    }

    private void drawIndicators(GuiGraphics guiGraphics, CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        int drawX = x + (Integer)crosshair.gap.get() + 5;
        int drawY = y + (Integer)crosshair.gap.get() + 5;
        List<ComputeIndicators.IndicatorItem> indicatorItems = computedProperties.indicatorItems();
        Matrix3x2fStack matrixStack = guiGraphics.pose();
        for (ComputeIndicators.IndicatorItem indicatorItem : indicatorItems) {
            matrixStack.scale(0.5f, 0.5f);
            guiGraphics.renderItem(indicatorItem.icon(), drawX * 2 - 8, drawY * 2 - 8);
            matrixStack.scale(2.0f, 2.0f);
            this.renderManager.drawSmallText(guiGraphics, indicatorItem.text(), drawX + 5, drawY, ModTheme.WHITE, true);
            drawX += 15;
        }
    }
}

