/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.component.components;

import com.wjbaker.ccm.crosshair.properties.BooleanProperty;
import com.wjbaker.ccm.gui.component.GuiComponent;
import com.wjbaker.ccm.gui.component.type.IBindableGuiComponent;
import com.wjbaker.ccm.gui.screen.GuiScreen;
import com.wjbaker.ccm.rendering.ModTheme;
import net.minecraft.client.gui.GuiGraphics;

public final class CheckBoxGuiComponent
extends GuiComponent
implements IBindableGuiComponent<BooleanProperty> {
    private final int boxSize;
    private final int labelSpacing;
    private final String label;
    private boolean isMouseOverBox;
    private BooleanProperty isChecked;

    public CheckBoxGuiComponent(GuiScreen parentGuiScreen, int x, int y, String label, boolean defaultValue) {
        super(parentGuiScreen, x, y, -1, -1);
        this.boxSize = 10;
        this.labelSpacing = 5;
        this.label = label;
        this.isMouseOverBox = false;
        this.isChecked = new BooleanProperty("fake_is_checked", defaultValue);
        this.width = this.boxSize + this.labelSpacing + this.renderManager.textWidth(this.label);
        this.height = this.boxSize;
    }

    @Override
    public void draw(GuiGraphics guiGraphics) {
        super.draw(guiGraphics);
        this.renderManager.drawBorderedRectangle(guiGraphics, this.x, this.y, this.x + this.boxSize, this.y + this.boxSize, 2.0f, ModTheme.DARK_GREY, this.currentBackgroundColour);
        float inset = 1.5f;
        if (((Boolean)this.isChecked.get()).booleanValue()) {
            this.renderManager.drawFilledRectangle(guiGraphics, (float)this.x + inset, (float)this.y + inset, (float)(this.x + this.boxSize) - inset, (float)(this.y + this.boxSize) - inset, ModTheme.SUCCESS);
        }
        this.renderManager.drawText(guiGraphics, this.label, this.x + this.boxSize + this.labelSpacing, this.y + this.boxSize / 2 - 3, this.currentTextColour, false);
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        super.onMouseMove(mouseX, mouseY);
        this.isMouseOverBox = this.isOverBox(mouseX, mouseY);
        this.currentBackgroundColour = this.isMouseOverBox ? this.hoverBackgroundColour : this.baseBackgroundColour;
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        super.onMouseUp(mouseX, mouseY, button);
        if (this.isOverBox(mouseX, mouseY)) {
            this.isChecked.set((Boolean)this.isChecked.get() == false);
        }
    }

    private boolean isOverBox(int mouseX, int mouseY) {
        return mouseX > this.x && mouseX <= this.x + this.boxSize && mouseY > this.y && mouseY <= this.y + this.boxSize;
    }

    @Override
    public void bind(BooleanProperty property) {
        this.isChecked = property;
    }
}

