/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.component.components;

import com.wjbaker.ccm.gui.component.GuiComponent;
import com.wjbaker.ccm.gui.component.event.IGuiComponentEvent;
import com.wjbaker.ccm.gui.component.event.IOnValueChangedEvent;
import com.wjbaker.ccm.gui.screen.GuiScreen;
import com.wjbaker.ccm.rendering.types.RGBA;
import net.minecraft.client.gui.GuiGraphics;

public abstract class SliderGuiComponent
extends GuiComponent {
    protected final int thumbSize;
    protected final int titleSpacing;
    protected final String label;
    protected final int minValue;
    protected final int maxValue;
    protected final int defaultValue;
    protected int thumbPosition;
    protected int grabOffset;
    protected boolean isDragging;
    private RGBA baseThumbColour;
    private RGBA hoverThumbColour;
    private RGBA currentThumbColour;

    public SliderGuiComponent(GuiScreen parentGuiScreen, int x, int y, int width, String label, int minValue, int maxValue, int defaultValue) {
        super(parentGuiScreen, x, y, width, 25);
        this.label = label;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
        this.thumbPosition = 0;
        this.grabOffset = 0;
        this.thumbSize = 11;
        this.titleSpacing = 3;
        this.baseThumbColour = this.baseBackgroundColour;
        this.hoverThumbColour = this.hoverBackgroundColour;
        this.currentThumbColour = this.baseBackgroundColour;
    }

    @Override
    public void draw(GuiGraphics guiGraphics) {
        super.draw(guiGraphics);
        this.renderManager.drawText(guiGraphics, this.label, this.x, this.y, this.currentTextColour, false);
        int posY = this.y + 8 + this.titleSpacing;
        this.renderManager.drawBorderedRectangle(guiGraphics, this.x, (float)posY + (float)this.thumbSize / 2.0f - 2.0f, this.x + this.width, (float)posY + (float)this.thumbSize / 2.0f - 1.0f + 3.0f, 2.0f, this.baseBorderColour, this.baseBackgroundColour);
        this.renderManager.drawBorderedRectangle(guiGraphics, this.x + this.thumbPosition, posY, this.x + this.thumbPosition + this.thumbSize, posY + this.thumbSize, 2.0f, this.currentBorderColour, this.currentThumbColour);
        this.drawLabel(guiGraphics);
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        super.onMouseDown(mouseX, mouseY, button);
        this.isDragging = this.isInsideThumb(mouseX, mouseY);
        if (this.isDragging) {
            this.grabOffset = mouseX - this.x - this.thumbPosition;
        }
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        super.onMouseMove(mouseX, mouseY);
        this.currentThumbColour = this.isInsideThumb(mouseX, mouseY) ? this.hoverThumbColour : this.baseThumbColour;
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        super.onMouseUp(mouseX, mouseY, button);
        this.isDragging = false;
    }

    private boolean isInsideThumb(int mouseX, int mouseY) {
        int posY = this.y + 8 + this.titleSpacing;
        return mouseX > this.x + this.thumbPosition && mouseX <= this.x + this.thumbPosition + this.thumbSize && mouseY > posY && mouseY <= posY + this.thumbSize;
    }

    @Override
    public void onMouseDrag(int startX, int startY, int mouseX, int mouseY) {
        super.onMouseDrag(startX, startY, mouseX, mouseY);
        if (!this.isDragging) {
            return;
        }
        int minPosition = 0;
        int maxPosition = this.width - this.thumbSize;
        int newPosition = mouseX - this.x - this.grabOffset;
        this.thumbPosition = Math.min(maxPosition, Math.max(minPosition, newPosition));
        this.calculateValue();
        for (IGuiComponentEvent event : this.events(IOnValueChangedEvent.class)) {
            event.invoke();
        }
    }

    protected abstract void calculateValue();

    protected abstract void drawLabel(GuiGraphics var1);

    public void setBaseThumbColour(RGBA baseThumbColour) {
        this.currentThumbColour = this.baseThumbColour = baseThumbColour;
    }

    public void setHoverThumbColour(RGBA hoverThumbColour) {
        this.hoverThumbColour = hoverThumbColour;
    }
}

