/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.screen;

import com.wjbaker.ccm.CustomCrosshairMod;
import com.wjbaker.ccm.gui.component.GuiComponent;
import com.wjbaker.ccm.gui.component.GuiComponentWithComponents;
import com.wjbaker.ccm.gui.component.components.ButtonGuiComponent;
import com.wjbaker.ccm.gui.component.event.IOnClickEvent;
import com.wjbaker.ccm.gui.screen.GuiScreenAdapter;
import com.wjbaker.ccm.helpers.Helper;
import com.wjbaker.ccm.rendering.ModTheme;
import com.wjbaker.ccm.rendering.RenderManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;

public abstract class GuiScreen
extends GuiScreenAdapter {
    protected final RenderManager renderManager = new RenderManager();
    protected final GuiScreen parentGuiScreen;
    protected final List<GuiComponent> components;
    protected final int headerHeight;
    private final ButtonGuiComponent newVersionButton;
    private final ButtonGuiComponent patreonButton;
    private final ButtonGuiComponent paypalButton;
    private final List<ButtonGuiComponent> buttons;

    public GuiScreen(String title) {
        this(title, null);
    }

    public GuiScreen(String title, GuiScreen parentGuiScreen) {
        super(title);
        this.parentGuiScreen = parentGuiScreen;
        this.components = new ArrayList<GuiComponent>();
        this.headerHeight = 35;
        this.buttons = new ArrayList<ButtonGuiComponent>();
        this.newVersionButton = new ButtonGuiComponent(this, -1, -1, 125, 25, I18n.get((String)"custom_crosshair_mod.screen.new_version", (Object[])new Object[0]));
        this.newVersionButton.setBaseBackgroundColour(ModTheme.TERTIARY);
        this.newVersionButton.setHoverBackgroundColour(ModTheme.TERTIARY_DARK);
        this.newVersionButton.setBaseTextColour(ModTheme.BLACK);
        this.newVersionButton.setHoverTextColour(ModTheme.BLACK);
        this.newVersionButton.addEvent(IOnClickEvent.class, () -> {
            if (!((Boolean)CustomCrosshairMod.INSTANCE.properties().isLatestVersion().get()).booleanValue()) {
                Helper.openInBrowser("https://www.curseforge.com/projects/242995/");
            }
        });
        if (!((Boolean)CustomCrosshairMod.INSTANCE.properties().isLatestVersion().get()).booleanValue()) {
            this.buttons.add(this.newVersionButton);
        }
        this.patreonButton = new ButtonGuiComponent(this, -1, -1, 125, 25, I18n.get((String)"custom_crosshair_mod.screen.support_on_patreon", (Object[])new Object[0]));
        this.patreonButton.setBaseBackgroundColour(ModTheme.SECONDARY);
        this.patreonButton.setHoverBackgroundColour(ModTheme.PRIMARY);
        this.patreonButton.setBaseTextColour(ModTheme.WHITE);
        this.patreonButton.setHoverTextColour(ModTheme.WHITE);
        this.patreonButton.addEvent(IOnClickEvent.class, () -> Helper.openInBrowser("https://www.patreon.com/bePatron?u=66431720"));
        this.buttons.add(this.patreonButton);
        this.paypalButton = new ButtonGuiComponent(this, -1, -1, 125, 25, I18n.get((String)"custom_crosshair_mod.screen.support_on_paypal", (Object[])new Object[0]));
        this.paypalButton.setBaseBackgroundColour(ModTheme.SECONDARY);
        this.paypalButton.setHoverBackgroundColour(ModTheme.PRIMARY);
        this.paypalButton.setBaseTextColour(ModTheme.WHITE);
        this.paypalButton.setHoverTextColour(ModTheme.WHITE);
        this.paypalButton.addEvent(IOnClickEvent.class, () -> Helper.openInBrowser("https://www.paypal.com/cgi-bin/webscr?return=https://www.curseforge.com/projects/242995&cn=Add+special+instructions+to+the+addon+author()&business=sparkless101%40gmail.com&bn=PP-DonationsBF:btn_donateCC_LG.gif:NonHosted&cancel_return=https://www.curseforge.com/projects/242995&lc=US&item_name=Custom+Crosshair+Mod+(from+curseforge.com)&cmd=_donations&rm=1&no_shipping=1&currency_code=USD"));
        this.buttons.add(this.paypalButton);
    }

    @Override
    public void update() {
        this.components.forEach(GuiComponent::update);
        int currentX = this.width;
        for (ButtonGuiComponent button : this.buttons) {
            button.setPosition(currentX -= button.getWidth() + 5, this.headerHeight / 2 - button.getHeight() / 2);
        }
    }

    @Override
    public void draw(GuiGraphics guiGraphics) {
        this.renderManager.drawFilledRectangle(guiGraphics, 0.0f, 0.0f, this.width, this.height, ModTheme.BLACK.setOpacity(140));
        this.components.forEach(x -> x.draw(guiGraphics));
        this.drawHeader(guiGraphics);
    }

    private void drawHeader(GuiGraphics guiGraphics) {
        this.renderManager.drawFilledRectangle(guiGraphics, 0.0f, 0.0f, this.width, this.headerHeight, ModTheme.PRIMARY);
        this.renderManager.drawLine(guiGraphics, 0.0f, this.headerHeight, this.width, this.headerHeight, 2.0f, ModTheme.DARK_GREY);
        int titleWidth = this.renderManager.textWidth("Custom Crosshair Mod");
        int centreY = this.headerHeight / 2 - 3;
        this.renderManager.drawText(guiGraphics, "Custom Crosshair Mod", 5, centreY, ModTheme.WHITE, true);
        this.renderManager.drawSmallText(guiGraphics, "v1.6.1-forge", 8 + titleWidth, this.headerHeight / 2, ModTheme.DARK_GREY, false);
        if (!((Boolean)CustomCrosshairMod.INSTANCE.properties().isLatestVersion().get()).booleanValue()) {
            this.newVersionButton.draw(guiGraphics);
        }
        this.patreonButton.draw(guiGraphics);
        this.paypalButton.draw(guiGraphics);
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        this.components.stream().filter(x -> x.isInsideComponent(mouseX, mouseY)).forEach(x -> x.onMouseDown(mouseX, mouseY, button));
        this.buttons.forEach(x -> x.onMouseDown(mouseX, mouseY, button));
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        this.components.forEach(x -> x.onMouseUp(mouseX, mouseY, button));
        this.buttons.forEach(x -> x.onMouseUp(mouseX, mouseY, button));
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        this.components.forEach(x -> x.onMouseMove(mouseX, mouseY));
        this.buttons.forEach(x -> x.onMouseMove(mouseX, mouseY));
    }

    @Override
    public void onMouseDrag(int startX, int startY, int mouseX, int mouseY) {
        this.components.forEach(x -> x.onMouseDrag(startX, startY, mouseX, mouseY));
    }

    @Override
    public void onMouseScrollUp() {
        this.components.forEach(GuiComponentWithComponents::onMouseScrollUp);
    }

    @Override
    public void onMouseScrollDown() {
        this.components.forEach(GuiComponentWithComponents::onMouseScrollDown);
    }

    @Override
    public void onKeyDown(int keyCode) {
        if (keyCode == 256 && this.parentGuiScreen != null) {
            Minecraft.getInstance().setScreen((Screen)this.parentGuiScreen);
        }
    }

    @Override
    public void onKeyUp(int keyCode) {
    }

    @Override
    public void close() {
        CustomCrosshairMod.INSTANCE.configManager().write();
    }
}

