/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.screen.screens.drawCrosshair.components;

import com.wjbaker.ccm.CustomCrosshairMod;
import com.wjbaker.ccm.crosshair.custom.CustomCrosshairDrawer;
import com.wjbaker.ccm.crosshair.properties.IntegerProperty;
import com.wjbaker.ccm.gui.component.GuiComponent;
import com.wjbaker.ccm.gui.screen.GuiScreen;
import com.wjbaker.ccm.rendering.ModTheme;
import com.wjbaker.ccm.rendering.types.RGBA;
import net.minecraft.client.gui.GuiGraphics;

public final class DrawCrosshairGuiComponent
extends GuiComponent {
    private static final int GRID_SIZE = 5;
    private final IntegerProperty imageSize;
    private final CustomCrosshairDrawer customCrosshairDrawer;
    private boolean isDrawing = false;
    private boolean isDragging = false;
    private int lastUpdatedX = -1;
    private int lastUpdatedY = -1;

    public DrawCrosshairGuiComponent(GuiScreen parentGuiScreen, int x, int y, IntegerProperty imageSize) {
        super(parentGuiScreen, x, y, (Integer)imageSize.get() * 5, (Integer)imageSize.get() * 5);
        this.imageSize = imageSize;
        this.customCrosshairDrawer = CustomCrosshairMod.INSTANCE.properties().getCustomCrosshairDrawer();
    }

    @Override
    public void draw(GuiGraphics guiGraphics) {
        super.draw(guiGraphics);
        Integer gridCount = (Integer)this.imageSize.get();
        for (int gridX = 0; gridX < gridCount; ++gridX) {
            for (int gridY = 0; gridY < gridCount; ++gridY) {
                this.renderManager.drawFilledRectangle(guiGraphics, this.x + 5 * gridX, this.y + 5 * gridY, this.x + 5 * gridX + 5, this.y + 5 * gridY + 5, this.getGridColour(gridX, gridY));
                if (this.customCrosshairDrawer.getAt(gridX, gridY) != 1) continue;
                this.renderManager.drawFilledRectangle(guiGraphics, this.x + 5 * gridX, this.y + 5 * gridY, this.x + 5 * gridX + 5, this.y + 5 * gridY + 5, (RGBA)CustomCrosshairMod.INSTANCE.properties().getCrosshair().colour.get());
            }
        }
    }

    private RGBA getGridColour(int x, int y) {
        boolean centerWhenEven;
        Integer imageSize = (Integer)this.imageSize.get();
        boolean isOdd = imageSize % 2 != 0;
        int middle = imageSize / 2;
        boolean centerWhenOdd = isOdd && x == middle && y == middle;
        boolean bl = centerWhenEven = !(isOdd || x != middle - 1 && x != middle || y != middle - 1 && y != middle);
        if (centerWhenOdd || centerWhenEven) {
            return ModTheme.DARK_GREY.setOpacity(220);
        }
        if (x % 2 == 0 && y % 2 == 0 || x % 2 != 0 && y % 2 != 0) {
            return ModTheme.WHITE.setOpacity(140);
        }
        return ModTheme.DARK_GREY.setOpacity(140);
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        super.onMouseDown(mouseX, mouseY, button);
        if (!this.isInsideComponent(mouseX, mouseY)) {
            return;
        }
        this.isDrawing = true;
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        super.onMouseUp(mouseX, mouseY, button);
        this.onDraw(mouseX, mouseY);
        this.isDrawing = false;
        this.isDragging = false;
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        super.onMouseMove(mouseX, mouseY);
        this.isDragging = true;
        this.onDraw(mouseX, mouseY);
    }

    private void onDraw(int x, int y) {
        if (!this.isInsideComponent(x, y)) {
            return;
        }
        if (!this.isDrawing) {
            return;
        }
        int relativeX = x - this.getX();
        int relativeY = y - this.getY();
        int imagePositionX = relativeX / 5;
        int imagePositionY = relativeY / 5;
        if (this.isDragging && this.lastUpdatedX == imagePositionX && this.lastUpdatedY == imagePositionY) {
            return;
        }
        if (imagePositionX >= 0 && imagePositionX < (Integer)this.imageSize.get() && imagePositionY >= 0 && imagePositionY < (Integer)this.imageSize.get()) {
            this.customCrosshairDrawer.togglePixel(imagePositionX, imagePositionY);
        }
        this.lastUpdatedX = imagePositionX;
        this.lastUpdatedY = imagePositionY;
    }
}

