/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.rendering;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wjbaker.ccm.rendering.types.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

@OnlyIn(value=Dist.CLIENT)
public record ModFilledGuiElementRenderState(Matrix3x2f pose, float[] points, RGBA colour) implements GuiElementRenderState
{
    public RenderPipeline pipeline() {
        return RenderPipelines.GUI;
    }

    public void buildVertices(VertexConsumer vertices) {
        for (int i = 0; i < this.points.length; i += 2) {
            vertices.addVertexWith2DPose(this.pose, this.points[i], this.points[i + 1]).setColor(this.colour.getRed(), this.colour.getGreen(), this.colour.getBlue(), this.colour.getOpacity());
        }
    }

    @NotNull
    public TextureSetup textureSetup() {
        return TextureSetup.noTexture();
    }

    @Nullable
    public ScreenRectangle scissorArea() {
        return null;
    }

    public ScreenRectangle bounds() {
        Window window = Minecraft.getInstance().getWindow();
        return new ScreenRectangle(0, 0, window.getGuiScaledWidth(), window.getGuiScaledHeight()).transformMaxBounds(this.pose);
    }
}

