/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.rendering;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wjbaker.ccm.rendering.types.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;

@OnlyIn(value=Dist.CLIENT)
public record ModLinesGuiElementRenderState(Matrix3x2f pose, Float[] points, RGBA colour) implements GuiElementRenderState
{
    public RenderPipeline pipeline() {
        return RenderPipelines.DEBUG_LINE_STRIP;
    }

    public void buildVertices(VertexConsumer vertices) {
        for (int i = 0; i < this.points.length; i += 2) {
            vertices.addVertexWith2DPose(this.pose, this.points[i].floatValue(), this.points[i + 1].floatValue()).setColor(this.colour.getRed(), this.colour.getGreen(), this.colour.getBlue(), this.colour.getOpacity());
        }
        vertices.addVertexWith2DPose(this.pose, this.points[this.points.length - 2].floatValue(), this.points[this.points.length - 1].floatValue()).setColor(this.colour.getRed(), this.colour.getGreen(), this.colour.getBlue(), this.colour.getOpacity());
    }

    @NotNull
    public TextureSetup textureSetup() {
        return TextureSetup.noTexture();
    }

    @Nullable
    public ScreenRectangle scissorArea() {
        Float minX = this.points[0];
        Float minY = this.points[1];
        Float maxX = this.points[0];
        Float maxY = this.points[1];
        for (int i = 2; i < this.points.length; ++i) {
            if (i % 2 == 0) {
                minX = Float.valueOf(Math.min(minX.floatValue(), this.points[i].floatValue()));
                maxX = Float.valueOf(Math.max(maxX.floatValue(), this.points[i].floatValue()));
                continue;
            }
            minY = Float.valueOf(Math.min(minY.floatValue(), this.points[i].floatValue()));
            maxY = Float.valueOf(Math.max(maxY.floatValue(), this.points[i].floatValue()));
        }
        Window window = Minecraft.getInstance().getWindow();
        return new ScreenRectangle(-minX.intValue(), -minY.intValue(), window.getGuiScaledWidth() + maxX.intValue(), window.getGuiScaledHeight() + maxY.intValue());
    }

    public ScreenRectangle bounds() {
        Window window = Minecraft.getInstance().getWindow();
        return new ScreenRectangle(0, 0, window.getGuiScaledWidth(), window.getGuiScaledHeight()).transformMaxBounds(this.pose);
    }
}

