/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.rendering;

import com.mojang.blaze3d.platform.Window;
import com.wjbaker.ccm.crosshair.custom.CustomCrosshairDrawer;
import com.wjbaker.ccm.gui.types.GuiBounds;
import com.wjbaker.ccm.gui.types.IDrawInsideWindowCallback;
import com.wjbaker.ccm.rendering.ModFilledGuiElementRenderState;
import com.wjbaker.ccm.rendering.ModLinesGuiElementRenderState;
import com.wjbaker.ccm.rendering.types.RGBA;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.lwjgl.opengl.GL11;

public final class RenderManager {
    private void setGlProperty(int property, boolean isEnabled) {
        if (isEnabled) {
            GL11.glEnable((int)property);
        } else {
            GL11.glDisable((int)property);
        }
    }

    public void drawLines(GuiGraphics guiGraphics, Float[] points, float thickness, RGBA colour) {
        this.drawLines(guiGraphics, points, thickness, colour, false);
    }

    public void drawLines(GuiGraphics guiGraphics, Float[] points, float thickness, RGBA colour, boolean isBlendEnabled) {
        guiGraphics.getRenderState().submitGuiElement((GuiElementRenderState)new ModLinesGuiElementRenderState(new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), points, colour));
    }

    public void drawFilledShape(GuiGraphics guiGraphics, float[] points, RGBA colour) {
        this.drawFilledShape(guiGraphics, points, colour, false);
    }

    public void drawFilledShape(GuiGraphics guiGraphics, float[] points, RGBA colour, boolean isBlendEnabled) {
        guiGraphics.getRenderState().submitGuiElement((GuiElementRenderState)new ModFilledGuiElementRenderState(new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), points, colour));
    }

    public void drawLine(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, float thickness, RGBA colour) {
        this.drawLines(guiGraphics, new Float[]{Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2)}, thickness, colour);
    }

    public void drawRectangle(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, float thickness, RGBA colour) {
        this.drawLines(guiGraphics, new Float[]{Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x1), Float.valueOf(y2), Float.valueOf(x1), Float.valueOf(y1)}, thickness, colour);
    }

    public void drawFilledRectangle(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, RGBA colour) {
        this.drawFilledRectangle(guiGraphics, x1, y1, x2, y2, colour, false);
    }

    public void drawFilledRectangle(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, RGBA colour, boolean isBlendEnabled) {
        this.drawFilledShape(guiGraphics, new float[]{x1, y1, x1, y2, x2, y2, x2, y1}, colour, isBlendEnabled);
    }

    public void drawBorderedRectangle(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, float borderThickness, RGBA borderColour, RGBA fillColour) {
        this.drawBorderedRectangle(guiGraphics, x1, y1, x2, y2, borderThickness, borderColour, fillColour, false);
    }

    public void drawBorderedRectangle(GuiGraphics guiGraphics, float x1, float y1, float x2, float y2, float borderThickness, RGBA borderColour, RGBA fillColour, boolean isBlendEnabled) {
        this.drawFilledRectangle(guiGraphics, x1, y1, x2, y2, fillColour, isBlendEnabled);
        this.drawRectangle(guiGraphics, x1, y1, x2, y2, borderThickness, borderColour);
    }

    public void drawPartialCircle(GuiGraphics guiGraphics, float x, float y, float radius, int startAngleAt, int endAngleAt, float thickness, RGBA colour) {
        int startAngle = Math.max(0, Math.min(startAngleAt, endAngleAt));
        int endAngle = Math.min(360, Math.max(startAngleAt, endAngleAt));
        float ratio = (float)Math.PI / 180;
        ArrayList<Float> points = new ArrayList<Float>();
        for (int i = startAngle; i <= endAngle; ++i) {
            float radians = (float)(i - 90) * ratio;
            points.add(Float.valueOf(x + (float)Math.cos(radians) * radius));
            points.add(Float.valueOf(y + (float)Math.sin(radians) * radius));
        }
        guiGraphics.getRenderState().submitGuiElement((GuiElementRenderState)new ModLinesGuiElementRenderState(new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), points.toArray(new Float[0]), colour));
    }

    public void drawCircle(GuiGraphics guiGraphics, float x, float y, float radius, float thickness, RGBA colour) {
        this.drawPartialCircle(guiGraphics, x, y, radius, 0, 360, thickness, colour);
        this.drawPartialCircle(guiGraphics, x, y, radius, 0, 360, thickness, colour);
    }

    public void drawImage(GuiGraphics guiGraphics, int x, int y, CustomCrosshairDrawer image, RGBA colour, boolean isCentered) {
        float offsetX = isCentered ? (float)image.getWidth() / 2.0f : 0.0f;
        float offsetY = isCentered ? (float)image.getHeight() / 2.0f : 0.0f;
        int width = image.getWidth();
        int height = image.getHeight();
        for (int imageX = 0; imageX < width; ++imageX) {
            for (int imageY = 0; imageY < height; ++imageY) {
                if (image.getAt(imageX, imageY) != 1) continue;
                float drawX = (float)(x + imageX) - offsetX;
                float drawY = (float)(y + imageY) - offsetY;
                this.drawFilledRectangle(guiGraphics, drawX, drawY, drawX + 1.0f, drawY + 1.0f, colour);
            }
        }
    }

    public void drawText(GuiGraphics guiGraphics, String text, int x, int y, RGBA colour, boolean hasShadow) {
        int colourAsInt = this.rgbaAsInt(colour);
        if (hasShadow) {
            guiGraphics.drawString(Minecraft.getInstance().font, text, x, y, colourAsInt, true);
        } else {
            guiGraphics.drawString(Minecraft.getInstance().font, text, x, y, colourAsInt);
        }
    }

    public void drawSmallText(GuiGraphics guiGraphics, String text, int x, int y, RGBA colour, boolean hasShadow) {
        Matrix3x2fStack matrixStack = guiGraphics.pose();
        matrixStack.pushMatrix();
        matrixStack.scale(0.5f, 0.5f);
        this.drawText(guiGraphics, text, x * 2, y * 2, colour, hasShadow);
        matrixStack.popMatrix();
    }

    public void drawBigText(GuiGraphics guiGraphics, String text, int x, int y, RGBA colour, boolean hasShadow) {
        Matrix3x2fStack matrixStack = guiGraphics.pose();
        matrixStack.pushMatrix();
        matrixStack.scale(1.5f, 1.5f);
        this.drawText(guiGraphics, text, (int)((float)x * 0.666f), (int)((float)y * 0.666f), colour, hasShadow);
        matrixStack.popMatrix();
    }

    private int rgbaAsInt(RGBA colour) {
        return (colour.getOpacity() << 24) + (colour.getRed() << 16) + (colour.getGreen() << 8) + colour.getBlue();
    }

    public int textWidth(String text) {
        return Minecraft.getInstance().font.width(text);
    }

    public void drawInsideBounds(GuiBounds bounds, IDrawInsideWindowCallback callback) {
        this.setGlProperty(3089, true);
        Window window = Minecraft.getInstance().getWindow();
        int scale = window.getGuiScale();
        GL11.glScissor((int)(bounds.x() * scale), (int)(window.getHeight() - bounds.y() * scale - bounds.height() * scale), (int)(bounds.width() * scale), (int)(bounds.height() * scale));
        callback.draw();
        this.setGlProperty(3089, false);
    }
}

