/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.config;

import com.wjbaker.ccm.CustomCrosshairMod;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.types.ICrosshairProperty;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class ConfigManager {
    private final String comment = "#";
    private final String[] header = new String[]{String.format("%s %s v%s", "#", "Custom Crosshair Mod", "1.6.4-fabric"), String.format("%s Made by Sparkless101", "#"), String.format("%s ------------------------------------", "#"), String.format("%s %s", "#", "https://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2637819/"), String.format("%s %s", "#", "https://www.curseforge.com/projects/242995/"), String.format("%s ------------------------------------", "#"), String.format("%s This config file contains the properties of the crosshair and mod properties. Feel free to edit them.", "#"), String.format("%s ------------------------------------", "#")};
    private final String fileName;
    private final CustomCrosshair crosshair;
    private final ICrosshairProperty<?>[] extraProperties;

    public ConfigManager(String fileName, CustomCrosshair crosshair, ICrosshairProperty<?> ... extraProperties) {
        this.fileName = fileName;
        this.crosshair = crosshair;
        this.extraProperties = extraProperties;
    }

    public boolean read() {
        boolean bl;
        BufferedReader reader = new BufferedReader(new FileReader(this.fileName));
        try {
            String currentLine;
            CustomCrosshairMod.INSTANCE.log("Config Manager (Read)", "Started reading file '{}'.", this.fileName);
            while ((currentLine = reader.readLine()) != null) {
                String[] lineSplit;
                if (currentLine.startsWith(this.comment) || (lineSplit = currentLine.split(":")).length == 0) continue;
                String alias = lineSplit[0].trim().toLowerCase();
                String value = lineSplit[1].trim().toLowerCase();
                ICrosshairProperty<?> property = this.getAllProperties().get(alias);
                if (property == null) continue;
                property.setFromConfig(value);
                CustomCrosshairMod.INSTANCE.log("Config Manager (Read)", "Set property '{}' to '{}'.", property.alias(), property.get());
            }
            CustomCrosshairMod.INSTANCE.log("Config Manager (Read)", "Finished reading file '{}'.", this.fileName);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                CustomCrosshairMod.INSTANCE.log("Config Manager (Read)", "Failed reading file '{}'.", this.fileName);
                return false;
            }
        }
        reader.close();
        return bl;
    }

    public boolean write() {
        boolean bl;
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.fileName));
        try {
            CustomCrosshairMod.INSTANCE.log("Config Manager (Write)", "Start writing file '{}'.", this.fileName);
            for (String line : this.header) {
                writer.write(line);
                writer.newLine();
            }
            for (ICrosshairProperty iCrosshairProperty : this.getAllProperties().values()) {
                writer.write(String.format("%s:%s", iCrosshairProperty.alias(), iCrosshairProperty.forConfig()));
                writer.newLine();
            }
            CustomCrosshairMod.INSTANCE.log("Config Manager (Write)", "Finished writing file '{}'.", this.fileName);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                CustomCrosshairMod.INSTANCE.log("Config Manager (Write)", "Failed writing file '{}'.", this.fileName);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    private Map<String, ICrosshairProperty<?>> getAllProperties() {
        ArrayList properties = new ArrayList();
        properties.addAll(this.crosshair.propertiesAsList);
        properties.addAll(Arrays.stream(this.extraProperties).toList());
        return properties.stream().collect(Collectors.toMap(ICrosshairProperty::alias, p -> p));
    }
}

