/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.custom;

import com.wjbaker.ccm.CustomCrosshairMod;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class CustomCrosshairDrawer {
    private final String file = "crosshair_drawn.ccmpng";
    private int width;
    private int height;
    private int[][] pixels;

    public CustomCrosshairDrawer() {
        this.reset(57, 57);
    }

    public void reset(int width, int height) {
        this.width = width;
        this.height = height;
        for (int[] row : this.pixels = new int[this.width][this.height]) {
            Arrays.fill(row, 0);
        }
    }

    public void togglePixel(int x, int y) {
        int newPixel;
        int currentPixel = this.pixels[x][y];
        this.pixels[x][y] = newPixel = currentPixel == 0 ? 1 : 0;
    }

    public void loadImage() {
        try {
            CustomCrosshairMod.INSTANCE.log("Drawn Crosshair (Read)", "Started reading drawn crosshair image.", new Object[0]);
            BufferedImage image = ImageIO.read(new File(this.file));
            this.reset(image.getWidth(), image.getHeight());
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    if (Math.abs(image.getRGB(x, y)) <= 1) continue;
                    this.togglePixel(x, y);
                }
            }
            CustomCrosshairMod.INSTANCE.log("Drawn Crosshair (Read)", "Finished reading drawn crosshair image.", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveImage() {
        try {
            CustomCrosshairMod.INSTANCE.log("Drawn Crosshair (Write)", "Started saving drawn crosshair image.", new Object[0]);
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
            Graphics2D graphics = bufferedImage.createGraphics();
            graphics.setPaint(Color.black);
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    if (this.pixels[x][y] != 1) continue;
                    graphics.drawRect(x, y, 0, 0);
                }
            }
            ImageIO.write((RenderedImage)bufferedImage, "PNG", new File(this.file));
            CustomCrosshairMod.INSTANCE.log("Drawn Crosshair (Write)", "Finished saving drawn crosshair image.", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getAt(int x, int y) {
        return this.pixels[x][y];
    }
}

