/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.styles;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.computed.ComputedProperties;
import com.wjbaker.ccm.crosshair.types.CrosshairStyle;
import com.wjbaker.ccm.rendering.types.RGBA;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public final class CrossStyle
extends CrosshairStyle {
    public CrossStyle(Matrix3x2fStack matrixStack, CustomCrosshair crosshair) {
        super(matrixStack, crosshair);
    }

    @Override
    public void draw(class_332 drawContext, int x, int y, ComputedProperties computedProperties) {
        Boolean isOutlineEnabled = (Boolean)this.crosshair.isOutlineEnabled.get();
        RGBA baseColour = computedProperties.colour();
        int gap = computedProperties.gap();
        float thickness = (float)((Integer)this.crosshair.thickness.get()).intValue() - 0.1f;
        Integer width = (Integer)this.crosshair.width.get();
        Integer height = (Integer)this.crosshair.height.get();
        Boolean isAdaptiveColourEnabled = (Boolean)this.crosshair.isAdaptiveColourEnabled.get();
        if (isOutlineEnabled.booleanValue()) {
            RGBA outlineColour = (RGBA)this.crosshair.outlineColour.get();
            float adjustedWidth = (float)width.intValue() + 1.0f;
            float adjustedHeight = (float)height.intValue() + 1.0f;
            float adjustedGap = (float)gap - 0.5f;
            this.renderManager.drawBorderedRectangle(drawContext, (float)x - thickness, (float)y - adjustedGap - adjustedHeight, (float)x + thickness, (float)y - adjustedGap, 2.0f, outlineColour, baseColour, isAdaptiveColourEnabled);
            this.renderManager.drawBorderedRectangle(drawContext, (float)x - thickness, (float)y + adjustedGap, (float)x + thickness, (float)y + adjustedGap + adjustedHeight, 2.0f, outlineColour, baseColour, isAdaptiveColourEnabled);
            this.renderManager.drawBorderedRectangle(drawContext, (float)x - adjustedGap - adjustedWidth, (float)y - thickness, (float)x - adjustedGap, (float)y + thickness, 2.0f, outlineColour, baseColour, isAdaptiveColourEnabled);
            this.renderManager.drawBorderedRectangle(drawContext, (float)x + adjustedGap, (float)y - thickness, (float)x + adjustedGap + adjustedWidth, (float)y + thickness, 2.0f, outlineColour, baseColour, isAdaptiveColourEnabled);
        } else {
            float adjustedThickness = thickness - 0.5f;
            this.renderManager.drawFilledRectangle(drawContext, (float)x - adjustedThickness, y - gap - height, (float)x + adjustedThickness, y - gap, baseColour, isAdaptiveColourEnabled);
            this.renderManager.drawFilledRectangle(drawContext, (float)x - adjustedThickness, y + gap, (float)x + adjustedThickness, y + gap + height, baseColour, isAdaptiveColourEnabled);
            this.renderManager.drawFilledRectangle(drawContext, x - gap - width, (float)y - adjustedThickness, x - gap, (float)y + adjustedThickness, baseColour, isAdaptiveColourEnabled);
            this.renderManager.drawFilledRectangle(drawContext, x + gap, (float)y - adjustedThickness, x + gap + width, (float)y + adjustedThickness, baseColour, isAdaptiveColourEnabled);
        }
    }
}

