/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.component.components;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.properties.RgbaProperty;
import com.wjbaker.ccm.gui.component.GuiComponent;
import com.wjbaker.ccm.gui.component.type.IBindableGuiComponent;
import com.wjbaker.ccm.gui.screen.GuiScreen;
import com.wjbaker.ccm.gui.screen.screens.editColour.EditColourGuiScreen;
import com.wjbaker.ccm.rendering.ModTheme;
import com.wjbaker.ccm.rendering.types.RGBA;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public final class ColourPickerGuiComponent
extends GuiComponent
implements IBindableGuiComponent<RgbaProperty> {
    private final int labelSpacing;
    private final int boxSize;
    private final String label;
    private final CustomCrosshair crosshair;
    private RgbaProperty colour;

    public ColourPickerGuiComponent(GuiScreen parentGuiScreen, CustomCrosshair crosshair, int x, int y, String label) {
        super(parentGuiScreen, x, y, -1, 25);
        this.crosshair = crosshair;
        this.labelSpacing = 3;
        this.boxSize = 25;
        this.label = label;
        this.colour = new RgbaProperty("fake_colour", ModTheme.WHITE);
        this.width = this.boxSize + this.labelSpacing + this.renderManager.textWidth(this.label);
    }

    @Override
    public void draw(class_332 drawContext) {
        super.draw(drawContext);
        this.renderManager.drawBorderedRectangle(drawContext, this.x, this.y, this.x + this.boxSize, this.y + this.boxSize, 2.0f, this.currentBorderColour, this.currentBackgroundColour);
        this.renderManager.drawFilledRectangle(drawContext, this.x + 2, this.y + 2, this.x + this.boxSize - 2, this.y + this.boxSize - 2, (RGBA)this.colour.get());
        this.renderManager.drawText(drawContext, this.label, this.x + this.boxSize + this.labelSpacing, this.y + this.boxSize / 2 - 3, ModTheme.WHITE, false);
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        super.onMouseMove(mouseX, mouseY);
        this.currentBackgroundColour = this.isInsideBox(mouseX, mouseY) ? this.hoverBackgroundColour : this.baseBackgroundColour;
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        super.onMouseDown(mouseX, mouseY, button);
        this.isMouseDownInside = this.isInsideBox(mouseX, mouseY);
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        super.onMouseUp(mouseX, mouseY, button);
        if (!this.isMouseDownInside) {
            return;
        }
        class_310.method_1551().method_1507((class_437)new EditColourGuiScreen(this.crosshair, this.colour));
        this.isMouseDownInside = false;
    }

    private boolean isInsideBox(int mouseX, int mouseY) {
        return mouseX > this.x && mouseX <= this.x + this.boxSize && mouseY > this.y && mouseY <= this.y + this.boxSize;
    }

    @Override
    public void bind(RgbaProperty property) {
        this.colour = property;
    }
}

