/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.screen;

import com.wjbaker.ccm.CustomCrosshairMod;
import com.wjbaker.ccm.gui.component.GuiComponent;
import com.wjbaker.ccm.gui.component.GuiComponentWithComponents;
import com.wjbaker.ccm.gui.component.components.ButtonGuiComponent;
import com.wjbaker.ccm.gui.component.event.IOnClickEvent;
import com.wjbaker.ccm.gui.screen.GuiScreenAdapter;
import com.wjbaker.ccm.helpers.Helper;
import com.wjbaker.ccm.rendering.ModTheme;
import com.wjbaker.ccm.rendering.RenderManager;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public abstract class GuiScreen
extends GuiScreenAdapter {
    protected final RenderManager renderManager = new RenderManager();
    protected final GuiScreen parentGuiScreen;
    protected final List<GuiComponent> components;
    protected final int headerHeight;
    private final ButtonGuiComponent newVersionButton;
    private final ButtonGuiComponent patreonButton;
    private final ButtonGuiComponent paypalButton;
    private final List<ButtonGuiComponent> buttons;

    public GuiScreen(String title) {
        this(title, null);
    }

    public GuiScreen(String title, GuiScreen parentGuiScreen) {
        super(title);
        this.parentGuiScreen = parentGuiScreen;
        this.components = new ArrayList<GuiComponent>();
        this.headerHeight = 35;
        this.buttons = new ArrayList<ButtonGuiComponent>();
        this.newVersionButton = new ButtonGuiComponent(this, -1, -1, 125, 25, class_1074.method_4662((String)"custom_crosshair_mod.screen.new_version", (Object[])new Object[0]));
        this.newVersionButton.setBaseBackgroundColour(ModTheme.TERTIARY);
        this.newVersionButton.setHoverBackgroundColour(ModTheme.TERTIARY_DARK);
        this.newVersionButton.setBaseTextColour(ModTheme.BLACK);
        this.newVersionButton.setHoverTextColour(ModTheme.BLACK);
        this.newVersionButton.addEvent(IOnClickEvent.class, () -> {
            if (!((Boolean)CustomCrosshairMod.INSTANCE.properties().isLatestVersion().get()).booleanValue()) {
                Helper.openInBrowser("https://www.curseforge.com/projects/242995/");
            }
        });
        if (!((Boolean)CustomCrosshairMod.INSTANCE.properties().isLatestVersion().get()).booleanValue()) {
            this.buttons.add(this.newVersionButton);
        }
        this.patreonButton = new ButtonGuiComponent(this, -1, -1, 125, 25, class_1074.method_4662((String)"custom_crosshair_mod.screen.support_on_patreon", (Object[])new Object[0]));
        this.patreonButton.setBaseBackgroundColour(ModTheme.SECONDARY);
        this.patreonButton.setHoverBackgroundColour(ModTheme.PRIMARY);
        this.patreonButton.setBaseTextColour(ModTheme.WHITE);
        this.patreonButton.setHoverTextColour(ModTheme.WHITE);
        this.patreonButton.addEvent(IOnClickEvent.class, () -> Helper.openInBrowser("https://www.patreon.com/bePatron?u=66431720"));
        this.buttons.add(this.patreonButton);
        this.paypalButton = new ButtonGuiComponent(this, -1, -1, 125, 25, class_1074.method_4662((String)"custom_crosshair_mod.screen.support_on_paypal", (Object[])new Object[0]));
        this.paypalButton.setBaseBackgroundColour(ModTheme.SECONDARY);
        this.paypalButton.setHoverBackgroundColour(ModTheme.PRIMARY);
        this.paypalButton.setBaseTextColour(ModTheme.WHITE);
        this.paypalButton.setHoverTextColour(ModTheme.WHITE);
        this.paypalButton.addEvent(IOnClickEvent.class, () -> Helper.openInBrowser("https://www.paypal.com/cgi-bin/webscr?return=https://www.curseforge.com/projects/242995&cn=Add+special+instructions+to+the+addon+author()&business=sparkless101%40gmail.com&bn=PP-DonationsBF:btn_donateCC_LG.gif:NonHosted&cancel_return=https://www.curseforge.com/projects/242995&lc=US&item_name=Custom+Crosshair+Mod+(from+curseforge.com)&cmd=_donations&rm=1&no_shipping=1&currency_code=USD"));
        this.buttons.add(this.paypalButton);
    }

    @Override
    public void update() {
        this.components.forEach(GuiComponent::update);
        int currentX = this.field_22789;
        for (ButtonGuiComponent button : this.buttons) {
            button.setPosition(currentX -= button.getWidth() + 5, this.headerHeight / 2 - button.getHeight() / 2);
        }
    }

    @Override
    public void draw(class_332 drawContext) {
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        this.renderManager.drawFilledRectangle(drawContext, 0.0f, 0.0f, this.field_22789, this.field_22790, ModTheme.BLACK.setOpacity(140));
        this.components.forEach(x -> x.draw(drawContext));
        this.drawHeader(drawContext);
    }

    private void drawHeader(class_332 drawContext) {
        this.renderManager.drawFilledRectangle(drawContext, 0.0f, 0.0f, this.field_22789, this.headerHeight, ModTheme.PRIMARY);
        this.renderManager.drawLine(drawContext, 0.0f, this.headerHeight, this.field_22789, this.headerHeight, 2.0f, ModTheme.DARK_GREY);
        int titleWidth = this.renderManager.textWidth("Custom Crosshair Mod");
        int centreY = this.headerHeight / 2 - 3;
        this.renderManager.drawText(drawContext, "Custom Crosshair Mod", 5, centreY, ModTheme.WHITE, true);
        this.renderManager.drawSmallText(drawContext, "v1.6.4-fabric", 8 + titleWidth, this.headerHeight / 2, ModTheme.DARK_GREY, false);
        if (!((Boolean)CustomCrosshairMod.INSTANCE.properties().isLatestVersion().get()).booleanValue()) {
            this.newVersionButton.draw(drawContext);
        }
        this.patreonButton.draw(drawContext);
        this.paypalButton.draw(drawContext);
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY, int button) {
        this.components.stream().filter(x -> x.isInsideComponent(mouseX, mouseY)).forEach(x -> x.onMouseDown(mouseX, mouseY, button));
        this.buttons.forEach(x -> x.onMouseDown(mouseX, mouseY, button));
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY, int button) {
        this.components.forEach(x -> x.onMouseUp(mouseX, mouseY, button));
        this.buttons.forEach(x -> x.onMouseUp(mouseX, mouseY, button));
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        this.components.forEach(x -> x.onMouseMove(mouseX, mouseY));
        this.buttons.forEach(x -> x.onMouseMove(mouseX, mouseY));
    }

    @Override
    public void onMouseDrag(int startX, int startY, int mouseX, int mouseY) {
        this.components.forEach(x -> x.onMouseDrag(startX, startY, mouseX, mouseY));
    }

    @Override
    public void onMouseScrollUp() {
        this.components.forEach(GuiComponentWithComponents::onMouseScrollUp);
    }

    @Override
    public void onMouseScrollDown() {
        this.components.forEach(GuiComponentWithComponents::onMouseScrollDown);
    }

    @Override
    public void onKeyDown(int keyCode) {
        if (keyCode == 256 && this.parentGuiScreen != null) {
            class_310.method_1551().method_1507((class_437)this.parentGuiScreen);
        }
    }

    @Override
    public void onKeyUp(int keyCode) {
    }

    @Override
    public void method_25419() {
        CustomCrosshairMod.INSTANCE.configManager().write();
        super.method_25419();
    }
}

