/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.rendering;

import com.wjbaker.ccm.crosshair.custom.CustomCrosshairDrawer;
import com.wjbaker.ccm.gui.types.GuiBounds;
import com.wjbaker.ccm.gui.types.IDrawInsideWindowCallback;
import com.wjbaker.ccm.rendering.ModFilledGuiElementRenderState;
import com.wjbaker.ccm.rendering.ModLinesGuiElementRenderState;
import com.wjbaker.ccm.rendering.types.RGBA;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_11244;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public final class RenderManager {
    private void setGlProperty(int property, boolean isEnabled) {
        if (isEnabled) {
            GL11.glEnable((int)property);
        } else {
            GL11.glDisable((int)property);
        }
    }

    public void drawLines(class_332 drawContext, Float[] points, float thickness, RGBA colour) {
        this.drawLines(drawContext, points, thickness, colour, false);
    }

    public void drawLines(class_332 drawContext, Float[] points, float thickness, RGBA colour, boolean isBlendEnabled) {
        drawContext.field_59826.method_70919((class_11244)new ModLinesGuiElementRenderState(new Matrix3x2f((Matrix3x2fc)drawContext.method_51448()), points, colour));
    }

    public void drawFilledShape(class_332 drawContext, float[] points, RGBA colour) {
        this.drawFilledShape(drawContext, points, colour, false);
    }

    public void drawFilledShape(class_332 drawContext, float[] points, RGBA colour, boolean isBlendEnabled) {
        drawContext.field_59826.method_70919((class_11244)new ModFilledGuiElementRenderState(new Matrix3x2f((Matrix3x2fc)drawContext.method_51448()), points, colour));
    }

    public void drawLine(class_332 drawContext, float x1, float y1, float x2, float y2, float thickness, RGBA colour) {
        this.drawLines(drawContext, new Float[]{Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2)}, thickness, colour);
    }

    public void drawRectangle(class_332 drawContext, float x1, float y1, float x2, float y2, float thickness, RGBA colour) {
        this.drawLines(drawContext, new Float[]{Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x1), Float.valueOf(y2), Float.valueOf(x1), Float.valueOf(y1)}, thickness, colour);
    }

    public void drawFilledRectangle(class_332 drawContext, float x1, float y1, float x2, float y2, RGBA colour) {
        this.drawFilledRectangle(drawContext, x1, y1, x2, y2, colour, false);
    }

    public void drawFilledRectangle(class_332 drawContext, float x1, float y1, float x2, float y2, RGBA colour, boolean isBlend) {
        this.drawFilledShape(drawContext, new float[]{x1, y1, x1, y2, x2, y2, x2, y1}, colour, isBlend);
    }

    public void drawBorderedRectangle(class_332 drawContext, float x1, float y1, float x2, float y2, float borderThickness, RGBA borderColour, RGBA fillColour) {
        this.drawBorderedRectangle(drawContext, x1, y1, x2, y2, borderThickness, borderColour, fillColour, false);
    }

    public void drawBorderedRectangle(class_332 drawContext, float x1, float y1, float x2, float y2, float borderThickness, RGBA borderColour, RGBA fillColour, boolean isBlend) {
        this.drawFilledRectangle(drawContext, x1, y1, x2, y2, fillColour, isBlend);
        this.drawRectangle(drawContext, x1, y1, x2, y2, borderThickness, borderColour);
    }

    public void drawPartialCircle(class_332 drawContext, float x, float y, float radius, int startAngleAt, int endAngleAt, float thickness, RGBA colour) {
        int startAngle = Math.max(0, Math.min(startAngleAt, endAngleAt));
        int endAngle = Math.min(360, Math.max(startAngleAt, endAngleAt));
        float ratio = (float)Math.PI / 180;
        ArrayList<Float> points = new ArrayList<Float>();
        for (int i = startAngle; i <= endAngle; ++i) {
            float radians = (float)(i - 90) * ratio;
            points.add(Float.valueOf(x + (float)Math.cos(radians) * radius));
            points.add(Float.valueOf(y + (float)Math.sin(radians) * radius));
        }
        drawContext.field_59826.method_70919((class_11244)new ModLinesGuiElementRenderState(new Matrix3x2f((Matrix3x2fc)drawContext.method_51448()), points.toArray(new Float[0]), colour));
    }

    public void drawCircle(class_332 drawContext, float x, float y, float radius, float thickness, RGBA colour) {
        this.drawPartialCircle(drawContext, x, y, radius, 0, 360, thickness, colour);
        this.drawPartialCircle(drawContext, x, y, radius, 0, 360, thickness, colour);
    }

    public void drawTorus(Matrix3x2fStack matrixStack, int x, int y, int innerRadius, int outerRadius, RGBA colour) {
    }

    public void drawImage(class_332 drawContext, int x, int y, CustomCrosshairDrawer image, RGBA colour, boolean isCentered) {
        float offsetX = isCentered ? (float)image.getWidth() / 2.0f : 0.0f;
        float offsetY = isCentered ? (float)image.getHeight() / 2.0f : 0.0f;
        int width = image.getWidth();
        int height = image.getHeight();
        for (int imageX = 0; imageX < width; ++imageX) {
            for (int imageY = 0; imageY < height; ++imageY) {
                if (image.getAt(imageX, imageY) != 1) continue;
                float drawX = (float)(x + imageX) - offsetX;
                float drawY = (float)(y + imageY) - offsetY;
                this.drawFilledRectangle(drawContext, drawX, drawY, drawX + 1.0f, drawY + 1.0f, colour);
            }
        }
    }

    public void drawText(class_332 drawContext, String text, int x, int y, RGBA colour, boolean hasShadow) {
        int colourAsInt = this.rgbaAsInt(colour);
        if (hasShadow) {
            drawContext.method_25303(class_310.method_1551().field_1772, text, x, y, colourAsInt);
        } else {
            drawContext.method_51433(class_310.method_1551().field_1772, text, x, y, colourAsInt, false);
        }
    }

    public void drawSmallText(class_332 drawContext, String text, int x, int y, RGBA colour, boolean hasShadow) {
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        matrixStack.pushMatrix();
        matrixStack.scale(0.5f, 0.5f);
        this.drawText(drawContext, text, x * 2, y * 2, colour, hasShadow);
        matrixStack.popMatrix();
    }

    public void drawBigText(class_332 drawContext, String text, int x, int y, RGBA colour, boolean hasShadow) {
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        matrixStack.pushMatrix();
        matrixStack.scale(1.5f, 1.5f);
        this.drawText(drawContext, text, (int)((float)x * 0.666f), (int)((float)y * 0.666f), colour, hasShadow);
        matrixStack.popMatrix();
    }

    private int rgbaAsInt(RGBA colour) {
        return (colour.getOpacity() << 24) + (colour.getRed() << 16) + (colour.getGreen() << 8) + colour.getBlue();
    }

    public int textWidth(String text) {
        return class_310.method_1551().field_1772.method_1727(text);
    }

    public void drawInsideBounds(GuiBounds bounds, IDrawInsideWindowCallback callback) {
        this.setGlProperty(3089, true);
        class_1041 window = class_310.method_1551().method_22683();
        int scale = window.method_4495();
        GL11.glScissor((int)Math.round(bounds.x() * scale), (int)Math.round(window.method_4507() - bounds.y() * scale - bounds.height() * scale), (int)Math.round(bounds.width() * scale), (int)Math.round(bounds.height() * scale));
        callback.draw();
        this.setGlProperty(3089, false);
    }
}

