package archives.tater.stagger;

import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

import static java.lang.Math.*;

import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_7225;

public class PoiseComponent implements AutoSyncedComponent, CommonTickingComponent {
    private final class_1657 player;

    private float damage = 0;
    private float lastDamage = 0;

    public PoiseComponent(class_1657 player) {
        this.player = player;
    }

    public float getDamage() {
        return damage;
    }

    public float getClientDamage(float tickDelta) {
        return lastDamage + (damage - lastDamage) * tickDelta;
    }

    public float getClientDamageProgress(float tickDelta) {
        return getClientDamage(tickDelta) / getMaxDamage();
    }

    public void setDamage(float damage) {
        this.damage = clamp(damage, 0, getMaxDamage());
        KEY.sync(player);
    }

    public void changeDamage(float damageChange) {
        damage = clamp(damage + damageChange, 0, getMaxDamage());
        KEY.sync(player);
    }

    public float getMaxDamage() {
        return (float) player.method_45325(StaggerAttributes.MAX_POISE);
    }

    public boolean isMax() {
        return damage >= getMaxDamage();
    }

    public boolean isEmptyClient() {
        return lastDamage <= 0;
    }

    private static final String DAMAGE_NBT = "damage";

    @Override
    public void readFromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        damage = nbtCompound.method_10583(DAMAGE_NBT);
    }

    @Override
    public void writeToNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        nbtCompound.method_10548(DAMAGE_NBT, damage);
    }

    @Override
    public void tick() {
        lastDamage = this.damage;
        if (damage > 0)
            damage = max(0, damage - (float) player.method_45325(StaggerAttributes.POISE_RATE));
    }

    public static final ComponentKey<PoiseComponent> KEY = ComponentRegistry.getOrCreate(Stagger.id("poise"), PoiseComponent.class);
}
