package archives.tater.stagger;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_746;

public class PoiseMeterRenderer {
    private PoiseMeterRenderer() {}

    private static final class_2960 POISE_BAR_BACKGROUND_TEXTURE = Stagger.id("textures/gui/sprites/poise_bar_background.png");
    private static final class_2960 POISE_BAR_PROGRESS_TEXTURE = Stagger.id("textures/gui/sprites/poise_bar_progress.png");

    public static boolean shouldRender(class_746 player) {
        return !PoiseComponent.KEY.get(player).isEmptyClient();
    }

    public static void render(class_332 context, int x, class_746 player, float tickDelta) {
        int width = 182;
        int centerDist = (int)((PoiseComponent.KEY.get(player).getClientDamageProgress(tickDelta)) * width) / 2;
        int y = context.method_51443() - 32 + 3;
        RenderSystem.enableBlend();
        context.method_25290(POISE_BAR_BACKGROUND_TEXTURE, x, y, 0, 0, width, 5, width, 5);
        if (centerDist > 0)
            //noinspection IntegerDivisionInFloatingPointContext intentional - pixel alignment
            context.method_25293(
                    POISE_BAR_PROGRESS_TEXTURE,
                    x + width / 2 - centerDist,
                    y,
                    centerDist * 2,
                    5,
                    width / 2 - centerDist,
                    0,
                    centerDist * 2,
                    5,
                    width,
                    5
            );

        RenderSystem.disableBlend();
    }
}
