package archives.tater.stagger;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1839;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import org.ladysnake.cca.api.v3.entity.EntityComponentFactoryRegistry;
import org.ladysnake.cca.api.v3.entity.EntityComponentInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static java.lang.Math.max;

public class Stagger implements ModInitializer, EntityComponentInitializer {
	public static final String MOD_ID = "stagger";

	public static class_2960 id(String path) {
		return class_2960.method_60655(MOD_ID, path);
	}

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	@Override
	public void registerEntityComponentFactories(EntityComponentFactoryRegistry entityComponentFactoryRegistry) {
		entityComponentFactoryRegistry.registerFor(class_1657.class, PoiseComponent.KEY, PoiseComponent::new);
	}

	@Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.
		StaggerAttributes.register();
		ServerLivingEntityEvents.AFTER_DAMAGE.register((entity, source, baseDamageTaken, damageTaken, blocked) -> {
			if (!blocked || !(entity instanceof class_1657 player)) return;
			var damageBlocked = max(baseDamageTaken - damageTaken, 0);
            if (damageBlocked == 0) return;
			var poiseComponent = PoiseComponent.KEY.get(player);
			poiseComponent.changeDamage(damageBlocked * (source.method_5526() instanceof class_1309 livingEntity ? (float) livingEntity.method_45325(StaggerAttributes.POISE_DAMAGE) : 1f));
			if (poiseComponent.isMax()) {
				var blockingItem = player.method_6030();
				if (blockingItem.method_7960() || blockingItem.method_7976() != class_1839.field_8949) return;
				player.method_7357().method_7906(blockingItem.method_7909(), (int) (20 * player.method_45325(StaggerAttributes.STAGGER_LENGTH)));
				player.method_6075();
				player.method_37908().method_43129(null, player, class_3417.field_15239, player.method_5634(), 1f, 1f);
			}
        });
	}
}