package archives.tater.stagger;

import net.minecraft.class_1320;
import net.minecraft.class_1320.class_9764;
import net.minecraft.class_1329;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class StaggerAttributes {
    private StaggerAttributes() {}

    private static class_6880<class_1320> register(String path, class_1320 attribute) {
        return class_2378.method_47985(class_7923.field_41190, Stagger.id(path), attribute);
    }

    private static String playerAttr(String name) {
        return "attribute.name." + Stagger.MOD_ID + '.' + name;
    }

    private static class_6880<class_1320> registerClamped(String name, double fallback, double min, double max, class_9764 category) {
        return register(name, new class_1329(playerAttr(name), fallback, min, max).method_26829(true).method_60493(category));
    }

    // TODO make these values named constants

    public static final class_6880<class_1320> MAX_POISE = registerClamped("max_poise", 20, 0, 100, class_9764.field_51885);
    public static final class_6880<class_1320> POISE_RATE = registerClamped("poise_rate", 0.025, 0, 2, class_9764.field_51885);
    public static final class_6880<class_1320> STAGGER_LENGTH = registerClamped("stagger_length", 5, 0, 10, class_9764.field_51887);
    public static final class_6880<class_1320> POISE_DAMAGE = registerClamped("poise_damage", 1, 0, 4, class_9764.field_51885);

    public static final class_2960 WEAPON_POISE_DAMAGE = Stagger.id("weapon_poise_damage");

    public static void addLivingEntityAttributes(class_5132.class_5133 attributeBuilder) {
        attributeBuilder.method_26867(POISE_DAMAGE);
    }

    public static void addPlayerAttributes(class_5132.class_5133 attributeBuilder) {
        attributeBuilder
                .method_26867(MAX_POISE)
                .method_26867(POISE_RATE)
                .method_26867(STAGGER_LENGTH);
    }

    public static void register() {}
}
