/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.stagger;

import archives.tater.stagger.Stagger;
import archives.tater.stagger.StaggerAttributes;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class PoiseComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1657 player;
    private float damage = 0.0f;
    private float lastDamage = 0.0f;
    private static final String DAMAGE_NBT = "damage";
    public static final ComponentKey<PoiseComponent> KEY = ComponentRegistry.getOrCreate((class_2960)Stagger.id("poise"), PoiseComponent.class);

    public PoiseComponent(class_1657 player) {
        this.player = player;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getClientDamage(float tickDelta) {
        return this.lastDamage + (this.damage - this.lastDamage) * tickDelta;
    }

    public float getClientDamageProgress(float tickDelta) {
        return this.getClientDamage(tickDelta) / this.getMaxDamage();
    }

    public void setDamage(float damage) {
        this.damage = Math.clamp(damage, 0.0f, this.getMaxDamage());
        KEY.sync((Object)this.player);
    }

    public void changeDamage(float damageChange) {
        this.damage = Math.clamp(this.damage + damageChange, 0.0f, this.getMaxDamage());
        KEY.sync((Object)this.player);
    }

    public float getMaxDamage() {
        return (float)this.player.method_45325(StaggerAttributes.MAX_POISE);
    }

    public boolean isMax() {
        return this.damage >= this.getMaxDamage();
    }

    public boolean isEmptyClient() {
        return this.lastDamage <= 0.0f;
    }

    public void readFromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        this.damage = nbtCompound.method_10583(DAMAGE_NBT);
    }

    public void writeToNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        nbtCompound.method_10548(DAMAGE_NBT, this.damage);
    }

    public void tick() {
        this.lastDamage = this.damage;
        if (this.damage > 0.0f) {
            this.damage = Math.max(0.0f, this.damage - (float)this.player.method_45325(StaggerAttributes.POISE_RATE));
        }
    }
}

