/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Commands;

import java.util.Arrays;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import rudynakodach.github.io.webhookintegrations.Modules.LanguageConfiguration;
import rudynakodach.github.io.webhookintegrations.WebhookActions;

public class SendToWebhook
implements CommandExecutor {
    final FileConfiguration config;
    final JavaPlugin plugin;
    final LanguageConfiguration language;

    public SendToWebhook(FileConfiguration cfg, JavaPlugin plugin) {
        this.config = cfg;
        this.plugin = plugin;
        this.language = LanguageConfiguration.get();
    }

    public boolean onCommand(@NotNull CommandSender sender, Command command, @NotNull String label, String[] args) {
        if (command.getName().equalsIgnoreCase("send")) {
            if (args.length >= 2) {
                String target = args[0];
                boolean isEmbed = Boolean.parseBoolean(args[1]);
                Object message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
                String username = sender instanceof ConsoleCommandSender ? "CONSOLE" : sender.getName();
                this.plugin.getLogger().log(Level.INFO, username + " used /send with the following message: " + (String)message);
                if (isEmbed) {
                    String json = "{\"embeds\": [ {\"title\": \"" + username + "\",\"description\": \"" + (String)message + "\"}]}";
                    new WebhookActions(this.plugin, target, json).SendAsync();
                } else {
                    message = username + ": " + (String)message;
                    String json = "{ \"content\": \"" + (String)message + "\" }";
                    new WebhookActions(this.plugin, target, json).SendAsync();
                }
                return true;
            }
            String response = ChatColor.translateAlternateColorCodes((char)'&', (String)(this.language.getLocalizedString("commands.send.commandIncorrectUsage") + "\n&r&f/send &aisEmbed&7(true/false)&r&a message"));
            sender.sendMessage(response);
            return true;
        }
        return false;
    }
}

