/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Commands;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import rudynakodach.github.io.webhookintegrations.Modules.LanguageConfiguration;

public class SetWebhookURL
implements CommandExecutor {
    final FileConfiguration config;
    final JavaPlugin plugin;
    final Logger logger;
    final LanguageConfiguration language;

    public SetWebhookURL(JavaPlugin plugin) {
        this.config = plugin.getConfig();
        this.plugin = plugin;
        this.logger = this.plugin.getLogger();
        this.language = LanguageConfiguration.get();
    }

    public boolean onCommand(@NotNull CommandSender sender, Command command, @NotNull String label, String[] args) {
        if (!command.getName().equalsIgnoreCase("seturl")) {
            return true;
        }
        if (args.length >= 1) {
            String newUrl = args[0].trim();
            String target = "main";
            if (args.length >= 2) {
                target = args[1].trim();
            }
            if (!newUrl.startsWith("https://")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.language.getLocalizedString("commands.seturl.noHttps"));
                return true;
            }
            if (!newUrl.contains("discord")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.language.getLocalizedString("commands.seturl.notDiscord"));
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.BLUE) + this.language.getLocalizedString("commands.seturl.verifyStart"));
            try {
                int responseCode = this.getResponseCode(newUrl);
                if (responseCode != 200 && responseCode != 204) {
                    sender.sendMessage(String.valueOf(ChatColor.LIGHT_PURPLE) + this.language.getLocalizedString("commands.seturl.verifyFail"));
                    return true;
                }
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.language.getLocalizedString("commands.seturl.verifySuccess"));
            }
            catch (IOException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + this.language.getLocalizedString("commands.seturl.verifyFail"));
                return true;
            }
            this.config.set("webhooks.%s".formatted(target), (Object)newUrl);
            this.plugin.saveConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.language.getLocalizedString("commands.seturl.newUrlSet").formatted(target));
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.LIGHT_PURPLE) + this.language.getLocalizedString("commands.seturl.commandIncorrectUsage"));
        return false;
    }

    private int getResponseCode(String target) throws IOException {
        String json = "{\"content\": \"**Connected!**\"}";
        URL url = new URL(target);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setDoOutput(true);
        OutputStream outputStream = connection.getOutputStream();
        outputStream.write(json.getBytes());
        outputStream.flush();
        outputStream.close();
        return connection.getResponseCode();
    }
}

