/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Commands;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rudynakodach.github.io.webhookintegrations.AutoUpdater;
import rudynakodach.github.io.webhookintegrations.Modules.LanguageConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.TemplateConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.WebhookIntegrationsModule;
import rudynakodach.github.io.webhookintegrations.Utils.Config.ConfigBackupManager;
import rudynakodach.github.io.webhookintegrations.WebhookActions;

public class WIActions
implements CommandExecutor,
TabCompleter {
    JavaPlugin plugin;

    public WIActions(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        if (command.getName().equalsIgnoreCase("wi")) {
            if (args.length >= 1) {
                if (args[0].equalsIgnoreCase("reset")) {
                    if (args.length < 2) {
                        commandSender.sendMessage("/wi reset confirm");
                        return true;
                    }
                    if (args[1].equalsIgnoreCase("confirm")) {
                        return this.resetConfig(commandSender);
                    }
                    if (!commandSender.hasPermission("webhookintegrations.config.reset")) {
                        commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("no-permission")));
                        return true;
                    }
                    commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("commands.config.noConfirm")));
                    return true;
                }
                if (args[0].equalsIgnoreCase("help")) {
                    if (commandSender instanceof Player) {
                        Player player = (Player)commandSender;
                        player.sendMessage(((TextComponent)Component.text((String)"View the official guide ").append(Component.text((String)"here").decorate(TextDecoration.BOLD).decorate(TextDecoration.UNDERLINED).clickEvent(ClickEvent.openUrl((String)"https://github.com/rudynakodach/WebhookIntegrations/blob/master/docs/guide.md")))).append(Component.text((String)" [CLICK]").color((TextColor)NamedTextColor.GRAY)));
                    } else {
                        commandSender.sendMessage("View the official guide here: https://github.com/rudynakodach/WebhookIntegrations/blob/master/docs/guide.md");
                    }
                } else {
                    if (args[0].equalsIgnoreCase("reload")) {
                        return this.reload(commandSender);
                    }
                    if (args[0].equalsIgnoreCase("update")) {
                        return this.update(commandSender);
                    }
                    if (args[0].equalsIgnoreCase("enable")) {
                        return this.enable(commandSender);
                    }
                    if (args[0].equalsIgnoreCase("disable")) {
                        return this.disable(commandSender);
                    }
                    if (args[0].equalsIgnoreCase("setlanguage")) {
                        return this.setLanguage(commandSender, args);
                    }
                    if (args[0].equalsIgnoreCase("config")) {
                        if (args.length < 2) {
                            commandSender.sendMessage("/wi config setvalue|savebackup|loadbackup");
                            return true;
                        }
                        if (args[1].equalsIgnoreCase("setvalue") && args.length >= 3) {
                            return this.setConfig(commandSender, args);
                        }
                        if (args[1].equalsIgnoreCase("savebackup")) {
                            return this.saveBackup(commandSender, args);
                        }
                        if (args[1].equalsIgnoreCase("loadbackup") && args.length >= 3) {
                            return this.loadBackup(commandSender, args);
                        }
                    }
                }
                if (args.length >= 2 && args[0].equalsIgnoreCase("template") && args[1].equalsIgnoreCase("send")) {
                    return this.sendTemplate(commandSender, args);
                }
            }
            commandSender.sendMessage("This server is running WebhookIntegrations");
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (command.getName().equalsIgnoreCase("wi")) {
            if (args.length == 1) {
                suggestions.add("help");
                suggestions.add("setlanguage");
                suggestions.add("reset");
                suggestions.add("enable");
                suggestions.add("disable");
                suggestions.add("reload");
                suggestions.add("update");
                suggestions.add("config");
                suggestions.add("template");
            } else if (args.length == 2) {
                if (args[0].equalsIgnoreCase("reset")) {
                    suggestions.add("confirm");
                } else {
                    if (args[0].equalsIgnoreCase("setlanguage")) {
                        return LanguageConfiguration.get().getYamlConfig().getKeys(false).stream().toList();
                    }
                    if (args[0].equalsIgnoreCase("config")) {
                        suggestions.add("setvalue");
                        suggestions.add("savebackup");
                        suggestions.add("loadbackup");
                    } else if (args[0].equalsIgnoreCase("template")) {
                        suggestions.add("send");
                    }
                }
            } else if (args.length == 3) {
                if (args[0].equalsIgnoreCase("config")) {
                    if (args[1].equalsIgnoreCase("setvalue")) {
                        return this.plugin.getConfig().getKeys(true).stream().toList();
                    }
                    if (args[1].equalsIgnoreCase("loadbackup")) {
                        File configBackupsDirectory = new File(this.plugin.getDataFolder(), "config-backups");
                        File[] backups = configBackupsDirectory.listFiles();
                        if (backups == null) {
                            return suggestions;
                        }
                        return Arrays.stream(backups).map(File::getName).collect(Collectors.toList());
                    }
                } else if (args[0].equalsIgnoreCase("template") && args[1].equalsIgnoreCase("send")) {
                    return new ArrayList<String>(TemplateConfiguration.get().getYamlConfig().getConfigurationSection("templates").getKeys(false));
                }
            } else if (args.length == 4 && args[0].equalsIgnoreCase("config") && args[1].equalsIgnoreCase("setvalue")) {
                if (!this.plugin.getConfig().contains(args[3])) {
                    return null;
                }
                Object value = this.plugin.getConfig().get(args[3]);
                if (value instanceof Boolean) {
                    suggestions.add("true");
                    suggestions.add("false");
                    return suggestions;
                }
            }
        }
        return suggestions;
    }

    @Contract(pure=true)
    @NotNull
    private String colorBoolean(Boolean b) {
        return String.valueOf(b != false ? ChatColor.GREEN : ChatColor.RED) + String.valueOf(b) + String.valueOf(ChatColor.RESET);
    }

    private boolean resetConfig(CommandSender commandSender) {
        if (!commandSender.hasPermission("webhookintegrations.config.reset")) {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("no-permission")));
            return true;
        }
        WebhookIntegrationsModule.resetAll();
        return true;
    }

    private boolean reload(CommandSender commandSender) {
        if (!commandSender.hasPermission("webhookintegrations.reload")) {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("no-permission")));
            return true;
        }
        this.plugin.reloadConfig();
        WebhookIntegrationsModule.reloadAll();
        commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("commands.config.reloadFinish")));
        return true;
    }

    private boolean update(CommandSender commandSender) {
        if (!commandSender.hasPermission("webhookintegrations.update")) {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("no-permission")));
            return true;
        }
        AutoUpdater updater = new AutoUpdater(this.plugin);
        try {
            int latestVersion = updater.getLatestVersion();
            if (latestVersion > 67) {
                boolean success = updater.Update();
                if (success) {
                    commandSender.sendMessage(LanguageConfiguration.get().getLocalizedString("commands.update.success"));
                } else {
                    commandSender.sendMessage(LanguageConfiguration.get().getLocalizedString("commands.update.failed"));
                }
            } else if (latestVersion == -1) {
                commandSender.sendMessage(LanguageConfiguration.get().getLocalizedString("commands.update.versionCheckFailed"));
            } else {
                commandSender.sendMessage(LanguageConfiguration.get().getLocalizedString("commands.update.latest"));
            }
        }
        catch (IOException ignored) {
            commandSender.sendMessage(LanguageConfiguration.get().getLocalizedString("commands.update.failed"));
        }
        return true;
    }

    private boolean enable(CommandSender commandSender) {
        if (!commandSender.hasPermission("webhookintegrations.enable")) {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("no-permission")));
            return true;
        }
        this.plugin.getConfig().set("isEnabled", (Object)true);
        this.plugin.saveConfig();
        this.plugin.reloadConfig();
        commandSender.sendMessage(LanguageConfiguration.get().getLocalizedString("commands.enable"));
        return true;
    }

    private boolean disable(CommandSender commandSender) {
        if (!commandSender.hasPermission("webhookintegrations.disable")) {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("no-permission")));
            return true;
        }
        this.plugin.getConfig().set("isEnabled", (Object)false);
        this.plugin.saveConfig();
        this.plugin.reloadConfig();
        commandSender.sendMessage(LanguageConfiguration.get().getLocalizedString("commands.disable"));
        return true;
    }

    private boolean setLanguage(CommandSender commandSender, String[] args) {
        if (!commandSender.hasPermission("webhookintegrations.setlanguage")) {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("no-permission")));
            return true;
        }
        if (args.length < 2) {
            commandSender.sendMessage("/wi setlanguage lang");
            return true;
        }
        String newLang = args[1];
        if (LanguageConfiguration.get().getYamlConfig().contains(newLang)) {
            this.plugin.getConfig().set("language-override", (Object)newLang);
            this.plugin.reloadConfig();
            LanguageConfiguration.get().setLanguage(newLang);
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("commands.setLang.changed")));
        } else {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("commands.setLang.notExists")));
        }
        return true;
    }

    private boolean setConfig(CommandSender commandSender, String[] args) {
        String message;
        if (!commandSender.hasPermission("webhookintegrations.config.setvalue")) {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("no-permission")));
            return true;
        }
        String path = args[2];
        Object value = args.length >= 4 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length)) : null;
        Object oldValue = null;
        if (this.plugin.getConfig().contains(path)) {
            oldValue = this.plugin.getConfig().get(path);
            message = LanguageConfiguration.get().getLocalizedString("commands.config.keyEdited");
        } else {
            message = LanguageConfiguration.get().getLocalizedString("commands.config.keyCreated");
        }
        if (value == null) {
            message = LanguageConfiguration.get().getLocalizedString("commands.config.keyRemoved");
        } else if (value.toString().equalsIgnoreCase("true")) {
            value = true;
        } else if (value.toString().equalsIgnoreCase("false")) {
            value = false;
        } else {
            try {
                value = Integer.parseInt(value.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.plugin.getConfig().set(path, value);
        try {
            this.plugin.getConfig().save(new File(this.plugin.getDataFolder(), "config.yml"));
        }
        catch (Exception e) {
            commandSender.sendMessage(LanguageConfiguration.get().getLocalizedString("commands.config.saveFailed").replace("%04", e.getMessage()));
            return true;
        }
        message = message.replace("%01", path).replace("%02", value instanceof String ? String.format("\"%s\"", value) : String.valueOf(value));
        if (oldValue != null) {
            message = message.replace("%03", oldValue.toString());
        }
        commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        return true;
    }

    private boolean saveBackup(CommandSender commandSender, String[] args) {
        String backupName;
        if (!commandSender.hasPermission("webhookintegrations.config.savebackup")) {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("no-permission")));
            return true;
        }
        String string = backupName = args.length >= 3 ? String.join((CharSequence)"_", Arrays.copyOfRange(args, 2, args.length)) : new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss-SSS").format(new Date());
        if (!ConfigBackupManager.get().saveBackup(backupName)) {
            commandSender.sendMessage("Failed to create backup");
        } else {
            String message = LanguageConfiguration.get().getLocalizedString("commands.config.backupCreated");
            message = message.replace("%01", backupName);
            message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
            commandSender.sendMessage(message);
        }
        return true;
    }

    private boolean loadBackup(CommandSender commandSender, String[] args) {
        if (!commandSender.hasPermission("webhookintegrations.config.loadbackup")) {
            commandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("no-permission")));
            return true;
        }
        String backupName = args[2];
        if (!ConfigBackupManager.get().backupExists(backupName)) {
            commandSender.sendMessage(Component.text((String)"Folder doesn't exist.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        ConfigBackupManager.get().loadBackup(backupName);
        String message = LanguageConfiguration.get().getLocalizedString("commands.config.backupLoaded");
        message = message.replace("%01", backupName);
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        commandSender.sendMessage(message);
        return true;
    }

    private boolean sendTemplate(CommandSender sender, String[] args) {
        if (!sender.hasPermission("webhookintegrations.templates.send")) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("no-permission")));
            return true;
        }
        String templateName = args[2];
        if (!TemplateConfiguration.Template.templateExists(templateName)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("commands.templates.notFound")));
            return true;
        }
        if (!sender.hasPermission("webhookintegrations.templates.send.%s".formatted(templateName)) || !sender.hasPermission("webhookintegrations.templates.send.any")) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("commands.templates.noAccess")));
            return true;
        }
        TemplateConfiguration.Template template = TemplateConfiguration.get().getTemplate(templateName);
        if (template == null || template.getJson() == null) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("commands.templates.noJson")));
            return true;
        }
        int argsOffset = 0;
        if (args.length >= 4 && !args[3].startsWith("--")) {
            argsOffset = 1;
            template.setTarget(args[3]);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (args.length >= 4 + argsOffset) {
            CharSequence[] commandArgs = Arrays.copyOfRange(args, 3 + argsOffset, args.length);
            String argsString = String.join((CharSequence)" ", commandArgs);
            Pattern argsPatters = Pattern.compile("--([a-zA-Z0-9]+) \"((?:[^\"\\\\]|\\\\.)+)\"");
            Matcher matcher = argsPatters.matcher(argsString);
            while (matcher.find()) {
                params.put(matcher.group(1), matcher.group(2));
            }
        }
        new WebhookActions(template.setJson(template.compile(params))).SendAsync();
        sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)LanguageConfiguration.get().getLocalizedString("commands.templates.success")));
        return true;
    }
}

