/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Events.Game;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import rudynakodach.github.io.webhookintegrations.Modules.MessageConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.MessageType;
import rudynakodach.github.io.webhookintegrations.Utils.Timeout.TimeoutManager;
import rudynakodach.github.io.webhookintegrations.WebhookActions;

public class PlayerChatListener
implements Listener {
    private final JavaPlugin plugin;

    public PlayerChatListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChatEvent(AsyncChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        MessageConfiguration.Message message = MessageConfiguration.get().getMessage(MessageType.PLAYER_CHAT);
        if (!message.canPlayerTrigger(event.getPlayer())) {
            return;
        }
        if (TimeoutManager.get().isTimedOut(event.getPlayer()) && this.plugin.getConfig().getBoolean("ignore-events-during-timeout", false)) {
            return;
        }
        boolean allowPlaceholdersInMessage = MessageConfiguration.get().getYamlConfig().getBoolean("onPlayerChat.allow-placeholders-in-message");
        String chatMessage = PlainTextComponentSerializer.plainText().serialize(event.message());
        String playerName = event.getPlayer().getName();
        if (this.plugin.getConfig().getBoolean("preventUsernameMarkdownFormatting")) {
            playerName = WebhookActions.escapeMarkdown(playerName);
        }
        String playerWorldName = event.getPlayer().getWorld().getName();
        String json = message.getJson();
        if (json == null) {
            return;
        }
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("censoring");
        if (section != null) {
            Set keys = section.getKeys(false);
            for (String key : keys) {
                chatMessage = chatMessage.replace(key, String.valueOf(this.plugin.getConfig().get("censoring." + key)));
            }
        }
        if (this.plugin.getConfig().getBoolean("remove-force-pings")) {
            chatMessage = chatMessage.replaceAll("<@[0-9]+>", "");
        }
        if (this.plugin.getConfig().getBoolean("remove-force-channel-pings")) {
            chatMessage = chatMessage.replaceAll("<#[0-9]+>", "");
        }
        if (this.plugin.getConfig().getBoolean("remove-force-role-pings")) {
            chatMessage = chatMessage.replaceAll("<@&[0-9]+>", "");
        }
        if (chatMessage.trim().equalsIgnoreCase("")) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("prevent-message-markdown-formatting", false)) {
            chatMessage = WebhookActions.escapeMarkdown(chatMessage);
        }
        if (this.plugin.getConfig().getBoolean("useRegexCensoring")) {
            List patterns = Objects.requireNonNull(this.plugin.getConfig().getConfigurationSection("regexCensoring")).getKeys(false).stream().toList();
            for (String expr : patterns) {
                chatMessage = chatMessage.replace(expr, Objects.requireNonNull(this.plugin.getConfig().getString("regexCensoring." + expr)));
            }
        }
        if (allowPlaceholdersInMessage) {
            json = json.replace("$message$", chatMessage);
            if (this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
                json = PlaceholderAPI.setPlaceholders((Player)event.getPlayer(), (String)json);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        sdf.setTimeZone(TimeZone.getTimeZone(this.plugin.getConfig().getString("timezone")));
        json = json.replace("$playersOnline$", String.valueOf(WebhookActions.getPlayerCount(this.plugin))).replace("$timestamp$", sdf.format(new Date())).replace("$maxPlayers$", String.valueOf(this.plugin.getServer().getMaxPlayers())).replace("$uuid$", event.getPlayer().getUniqueId().toString()).replace("$rawUsername$", event.getPlayer().getName()).replace("$player$", playerName).replace("$time$", new SimpleDateFormat(this.plugin.getConfig().getString("date-format", "HH:mm:ss")).format(new Date())).replace("$world$", playerWorldName);
        if (!allowPlaceholdersInMessage) {
            if (this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
                json = PlaceholderAPI.setPlaceholders((Player)event.getPlayer(), (String)json);
            }
            json = json.replace("$message$", chatMessage);
        }
        if (this.plugin.getConfig().getBoolean("remove-color-coding", false)) {
            json = WebhookActions.removeColorCoding(this.plugin, json);
        }
        new WebhookActions(message.setJson(json)).setHeaders(MessageType.PLAYER_CHAT).SendAsync();
    }
}

